/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.vertexium.TextIndexHint;
import org.vertexium.VertexiumException;

public class PropertyDefinition
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String propertyName;
    private final Class dataType;
    private final Set<TextIndexHint> textIndexHints;
    private final Double boost;
    private final boolean sortable;

    public PropertyDefinition(String propertyName, Class dataType, Set<TextIndexHint> textIndexHints) {
        this(propertyName, dataType, textIndexHints, null, false);
    }

    public PropertyDefinition(String propertyName, Class dataType, Set<TextIndexHint> textIndexHints, Double boost, boolean sortable) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.textIndexHints = textIndexHints;
        this.boost = boost;
        this.sortable = sortable;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public Set<TextIndexHint> getTextIndexHints() {
        return this.textIndexHints;
    }

    public Double getBoost() {
        return this.boost;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public static PropertyDefinition findPropertyDefinition(Collection<PropertyDefinition> propertyDefinitions, String propertyName) {
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            if (!propertyDefinition.getPropertyName().equals(propertyName)) continue;
            return propertyDefinition;
        }
        throw new VertexiumException("Could not find property definition for property name: " + propertyName);
    }

    public String toString() {
        return "PropertyDefinition{propertyName='" + this.propertyName + '\'' + ", dataType=" + this.dataType + ", textIndexHints=" + this.textIndexHints + ", boost=" + this.boost + ", sortable=" + this.sortable + '}';
    }
}

