/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.util;

import java.io.Closeable;
import java.io.IOException;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class CloseableUtils {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(CloseableUtils.class);

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to close", ex);
        }
    }

    public static void closeQuietly(Object ... objects) {
        for (Object object : objects) {
            if (!(object instanceof Closeable)) continue;
            CloseableUtils.closeQuietly((Closeable)object);
        }
    }
}

