/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf;

import net.fortytwo.flow.Sink;
import net.fortytwo.flow.rdf.RDFSink;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;

public class SingleContextPipe
implements RDFSink {
    private final Sink<Statement> stSink;
    private final Sink<Namespace> nsSink;
    private final Sink<String> cmtSink;

    public SingleContextPipe(RDFSink sink, final Resource context, final ValueFactory valueFactory) {
        final Sink<Statement> otherStSink = sink.statementSink();
        this.stSink = new Sink<Statement>(){

            public void put(Statement st) throws RippleException {
                Statement newSt = valueFactory.createStatement(st.getSubject(), st.getPredicate(), st.getObject(), context);
                otherStSink.put((Object)newSt);
            }
        };
        this.nsSink = sink.namespaceSink();
        this.cmtSink = sink.commentSink();
    }

    @Override
    public Sink<Statement> statementSink() {
        return this.stSink;
    }

    @Override
    public Sink<Namespace> namespaceSink() {
        return this.nsSink;
    }

    @Override
    public Sink<String> commentSink() {
        return this.cmtSink;
    }
}

