/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.tools.shell.CommandSupport;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.vertexium.Authorizations;
import org.vertexium.cli.VertexiumScript;

public class SetAuthsCommand
extends CommandSupport {
    public SetAuthsCommand(Groovysh shell) {
        super(shell, ":setauths", ":sa");
    }

    public Object execute(List<String> args) {
        List<String> auths = SetAuthsCommand.parseAuths(args);
        Authorizations authorizations = VertexiumScript.getGraph().createAuthorizations(auths.toArray(new String[auths.size()]));
        VertexiumScript.setAuthorizations(authorizations);
        return authorizations;
    }

    static List<String> parseAuths(List<String> args) {
        ArrayList<String> auths = new ArrayList<String>();
        for (String arg : args) {
            auths.addAll(SetAuthsCommand.parseAuths(arg));
        }
        return auths;
    }

    private static Collection<String> parseAuths(String arg) {
        ArrayList<String> auths = new ArrayList<String>();
        for (int i = 0; i < arg.length(); ++i) {
            String auth;
            int end;
            int start;
            char ch = arg.charAt(i);
            if (ch == '\'') {
                start = i + 1;
                end = arg.indexOf(39, start);
                if (end == -1) {
                    throw new RuntimeException("Missing end '");
                }
                auths.add(arg.substring(start, end));
                i = end + 1;
                continue;
            }
            if (ch == '\"') {
                start = i + 1;
                end = arg.indexOf(34, start);
                if (end == -1) {
                    throw new RuntimeException("Missing end \"");
                }
                auths.add(arg.substring(start, end));
                i = end + 1;
                continue;
            }
            if (Character.isWhitespace(ch)) continue;
            start = i;
            end = arg.indexOf(44, start);
            if (end == -1) {
                end = arg.length();
            }
            if ((auth = arg.substring(start, end).trim()).length() > 0) {
                auths.add(auth);
            }
            i = end;
        }
        return auths;
    }
}

