/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;

public class DefaultConfiguration
extends AccumuloConfiguration {
    private static final Map<String, String> resolvedProps;

    public static DefaultConfiguration getInstance() {
        return new DefaultConfiguration();
    }

    @Override
    public String get(Property property) {
        return resolvedProps.get(property.getKey());
    }

    @Override
    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        for (Map.Entry<String, String> entry : resolvedProps.entrySet()) {
            if (!filter.accept(entry.getKey())) continue;
            props.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        for (Property prop : Property.values()) {
            if (prop.getType().equals((Object)PropertyType.PREFIX)) continue;
            m.put(prop.getKey(), prop.getDefaultValue());
        }
        ConfigSanityCheck.validate(m.entrySet());
        resolvedProps = Collections.unmodifiableMap(m);
    }
}

