/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.cassandra;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.FaunusVertexQueryFilter;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraInputFormat;
import java.io.IOException;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanCassandraRecordReader
extends RecordReader<NullWritable, FaunusVertex> {
    private static final Logger log = LoggerFactory.getLogger(TitanCassandraRecordReader.class);
    protected ColumnFamilyRecordReader reader;
    protected TitanCassandraInputFormat inputFormat;
    protected TitanCassandraHadoopGraph graph;
    protected FaunusVertexQueryFilter vertexQuery;
    protected Configuration configuration;
    protected FaunusVertex vertex;

    public TitanCassandraRecordReader(TitanCassandraInputFormat inputFormat, FaunusVertexQueryFilter vertexQuery, ColumnFamilyRecordReader reader) {
        this.inputFormat = inputFormat;
        this.vertexQuery = vertexQuery;
        this.reader = reader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.graph = new TitanCassandraHadoopGraph(this.inputFormat.getGraphSetup());
        this.reader.initialize(inputSplit, taskAttemptContext);
        this.configuration = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration(taskAttemptContext));
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            FaunusVertex temp = this.graph.readHadoopVertex(this.configuration, this.reader.getCurrentKey().duplicate(), this.reader.getCurrentValue());
            if (null == temp) continue;
            this.vertex = temp;
            this.vertexQuery.filterRelationsOf(this.vertex);
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public FaunusVertex getCurrentValue() throws IOException, InterruptedException {
        return this.vertex;
    }

    public void close() throws IOException {
        this.graph.close();
        this.reader.close();
    }

    public float getProgress() {
        return this.reader.getProgress();
    }
}

