/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.ElementFactory;
import com.tinkerpop.blueprints.util.io.graphson.ElementPropertyConfig;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopGraphSONUtility {
    private static final Logger log = LoggerFactory.getLogger(HadoopGraphSONUtility.class);
    private static final String _OUT_E = "_outE";
    private static final String _IN_E = "_inE";
    private static final ImmutableSet<String> VERTEX_IGNORE = ImmutableSet.of((Object)"_type", (Object)"_outE", (Object)"_inE");
    private static final ImmutableSet<String> EDGE_IGNORE = ImmutableSet.of((Object)"_type", (Object)"_outV", (Object)"_inV");
    private final HadoopElementFactory elementFactory;
    private final GraphSONUtility graphson;

    public HadoopGraphSONUtility(Configuration configuration) {
        this.elementFactory = new HadoopElementFactory(configuration);
        this.graphson = new GraphSONUtility(GraphSONMode.COMPACT, (ElementFactory)this.elementFactory, ElementPropertyConfig.excludeProperties(VERTEX_IGNORE, EDGE_IGNORE));
    }

    public List<FaunusVertex> fromJSON(InputStream in) throws IOException {
        String line;
        LinkedList<FaunusVertex> vertices = new LinkedList<FaunusVertex>();
        BufferedReader bfs = new BufferedReader(new InputStreamReader(in));
        while ((line = bfs.readLine()) != null) {
            vertices.add(this.fromJSON(line));
        }
        bfs.close();
        return vertices;
    }

    public FaunusVertex fromJSON(String line) throws IOException {
        try {
            JSONObject json = new JSONObject(new JSONTokener(line));
            FaunusVertex vertex = (FaunusVertex)this.graphson.vertexFromJson(json);
            this.fromJSONEdges(vertex, json.optJSONArray(_OUT_E), Direction.OUT);
            json.remove(_OUT_E);
            this.fromJSONEdges(vertex, json.optJSONArray(_IN_E), Direction.IN);
            json.remove(_IN_E);
            return vertex;
        }
        catch (Exception e) {
            log.error("JSON parse exception", (Throwable)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    private void fromJSONEdges(FaunusVertex vertex, JSONArray edges, Direction direction) throws JSONException, IOException {
        if (null != edges) {
            for (int i = 0; i < edges.length(); ++i) {
                JSONObject edge = edges.optJSONObject(i);
                StandardFaunusEdge faunusEdge = null;
                if (direction.equals((Object)Direction.IN)) {
                    faunusEdge = (StandardFaunusEdge)this.graphson.edgeFromJson(edge, (Vertex)new FaunusVertex(vertex.getFaunusConf(), edge.optLong("_outV")), (Vertex)vertex);
                } else if (direction.equals((Object)Direction.OUT)) {
                    faunusEdge = (StandardFaunusEdge)this.graphson.edgeFromJson(edge, (Vertex)vertex, (Vertex)new FaunusVertex(vertex.getFaunusConf(), edge.optLong("_inV")));
                }
                if (faunusEdge == null) continue;
                vertex.addEdge(direction, faunusEdge);
            }
        }
    }

    public JSONObject toJSON(Vertex vertex) throws IOException {
        try {
            JSONObject edgeObject;
            JSONObject object = GraphSONUtility.jsonFromElement((Element)vertex, HadoopGraphSONUtility.getElementPropertyKeys((Element)vertex, false), (GraphSONMode)GraphSONMode.COMPACT);
            object.put("_id", (Object)Long.valueOf(object.remove("_id").toString()));
            Iterator edges = vertex.getEdges(Direction.OUT, new String[0]).iterator();
            if (edges.hasNext()) {
                JSONArray outEdgesArray = new JSONArray();
                while (edges.hasNext()) {
                    Edge outEdge = (Edge)edges.next();
                    edgeObject = GraphSONUtility.jsonFromElement((Element)outEdge, HadoopGraphSONUtility.getElementPropertyKeys((Element)outEdge, true), (GraphSONMode)GraphSONMode.COMPACT);
                    outEdgesArray.put((Object)edgeObject);
                }
                object.put(_OUT_E, (Object)outEdgesArray);
            }
            if ((edges = vertex.getEdges(Direction.IN, new String[0]).iterator()).hasNext()) {
                JSONArray inEdgesArray = new JSONArray();
                while (edges.hasNext()) {
                    Edge inEdge = (Edge)edges.next();
                    edgeObject = GraphSONUtility.jsonFromElement((Element)inEdge, HadoopGraphSONUtility.getElementPropertyKeys((Element)inEdge, false), (GraphSONMode)GraphSONMode.COMPACT);
                    inEdgesArray.put((Object)edgeObject);
                }
                object.put(_IN_E, (Object)inEdgesArray);
            }
            return object;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    private static Set<String> getElementPropertyKeys(Element element, boolean edgeIn) {
        HashSet<String> elementPropertyKeys = new HashSet<String>(element.getPropertyKeys());
        elementPropertyKeys.add("_id");
        if (element instanceof Edge) {
            if (edgeIn) {
                elementPropertyKeys.add("_inV");
            } else {
                elementPropertyKeys.add("_outV");
            }
            elementPropertyKeys.add("_label");
        }
        return elementPropertyKeys;
    }

    private static class HadoopElementFactory
    implements ElementFactory<FaunusVertex, StandardFaunusEdge> {
        private Configuration configuration;

        private HadoopElementFactory(Configuration configuration) {
            this.configuration = configuration;
        }

        public StandardFaunusEdge createEdge(Object id, FaunusVertex out, FaunusVertex in, String label) {
            return new StandardFaunusEdge(this.configuration, this.convertIdentifier(id), out.getLongId(), in.getLongId(), label);
        }

        public FaunusVertex createVertex(Object id) {
            return new FaunusVertex(this.configuration, this.convertIdentifier(id));
        }

        private long convertIdentifier(Object id) {
            if (id instanceof Long) {
                return (Long)id;
            }
            long identifier = -1L;
            if (id != null) {
                try {
                    identifier = Long.parseLong(id.toString());
                }
                catch (NumberFormatException e) {
                    identifier = -1L;
                }
            }
            return identifier;
        }
    }
}

