/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.types.vertices;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.TitanSchemaCategory;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.transaction.RelationConstructor;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.graphdb.types.SchemaSource;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionCategory;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionDescription;
import com.thinkaurelius.titan.graphdb.types.TypeDefinitionMap;
import com.thinkaurelius.titan.graphdb.types.indextype.CompositeIndexTypeWrapper;
import com.thinkaurelius.titan.graphdb.types.indextype.MixedIndexTypeWrapper;
import com.thinkaurelius.titan.graphdb.types.system.BaseKey;
import com.thinkaurelius.titan.graphdb.types.system.BaseLabel;
import com.thinkaurelius.titan.graphdb.vertices.CacheVertex;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import javax.annotation.Nullable;

public class TitanSchemaVertex
extends CacheVertex
implements SchemaSource {
    private String name = null;
    private TypeDefinitionMap definition = null;
    private ListMultimap<TypeDefinitionCategory, SchemaSource.Entry> outRelations = null;
    private ListMultimap<TypeDefinitionCategory, SchemaSource.Entry> inRelations = null;

    public TitanSchemaVertex(StandardTitanTx tx, long id, byte lifecycle) {
        super(tx, id, lifecycle);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            TitanProperty p;
            if (this.isLoaded()) {
                StandardTitanTx tx = this.tx();
                p = (TitanProperty)Iterables.getOnlyElement(RelationConstructor.readRelation((InternalVertex)this, tx.getGraph().getSchemaCache().getSchemaRelations(this.getLongId(), BaseKey.SchemaName, Direction.OUT), tx), null);
            } else {
                p = (TitanProperty)Iterables.getOnlyElement(((VertexCentricQueryBuilder)this.query().type(BaseKey.SchemaName)).properties(), null);
            }
            Preconditions.checkState((p != null ? 1 : 0) != 0, (String)"Could not find type for id: %s", (Object[])new Object[]{this.getLongId()});
            this.name = (String)p.getValue();
        }
        assert (this.name != null);
        return TitanSchemaCategory.getName(this.name);
    }

    @Override
    protected Vertex getVertexLabelInternal() {
        return null;
    }

    @Override
    public TypeDefinitionMap getDefinition() {
        TypeDefinitionMap def = this.definition;
        if (def == null) {
            Iterable<TitanRelation> ps;
            def = new TypeDefinitionMap();
            if (this.isLoaded()) {
                StandardTitanTx tx = this.tx();
                ps = RelationConstructor.readRelation((InternalVertex)this, tx.getGraph().getSchemaCache().getSchemaRelations(this.getLongId(), BaseKey.SchemaDefinitionProperty, Direction.OUT), tx);
            } else {
                ps = ((VertexCentricQueryBuilder)this.query().type(BaseKey.SchemaDefinitionProperty)).properties();
            }
            for (TitanProperty property : ps) {
                TypeDefinitionDescription desc = (TypeDefinitionDescription)property.getProperty(BaseKey.SchemaDefinitionDesc);
                Preconditions.checkArgument((desc != null && desc.getCategory().isProperty() ? 1 : 0) != 0);
                def.setValue(desc.getCategory(), property.getValue());
            }
            assert (def.size() > 0);
            this.definition = def;
        }
        assert (def != null);
        return def;
    }

    @Override
    public Iterable<SchemaSource.Entry> getRelated(TypeDefinitionCategory def, Direction dir) {
        ImmutableListMultimap rels;
        assert (dir == Direction.OUT || dir == Direction.IN);
        Object object = rels = dir == Direction.OUT ? this.outRelations : this.inRelations;
        if (rels == null) {
            Iterable<TitanRelation> edges;
            ImmutableListMultimap.Builder b = ImmutableListMultimap.builder();
            if (this.isLoaded()) {
                StandardTitanTx tx = this.tx();
                edges = RelationConstructor.readRelation((InternalVertex)this, tx.getGraph().getSchemaCache().getSchemaRelations(this.getLongId(), BaseLabel.SchemaDefinitionEdge, dir), tx);
            } else {
                edges = ((VertexCentricQueryBuilder)((VertexCentricQueryBuilder)this.query().type(BaseLabel.SchemaDefinitionEdge)).direction(dir)).titanEdges();
            }
            for (TitanEdge edge : edges) {
                TitanVertex oth = edge.getVertex(dir.opposite());
                assert (oth instanceof TitanSchemaVertex);
                TypeDefinitionDescription desc = (TypeDefinitionDescription)edge.getProperty(BaseKey.SchemaDefinitionDesc);
                Object modifier = null;
                if (desc.getCategory().hasDataType()) {
                    assert (desc.getModifier() != null && desc.getModifier().getClass().equals(desc.getCategory().getDataType()));
                    modifier = desc.getModifier();
                }
                b.put((Object)desc.getCategory(), (Object)new SchemaSource.Entry((TitanSchemaVertex)oth, modifier));
            }
            rels = b.build();
            if (dir == Direction.OUT) {
                this.outRelations = rels;
            } else {
                this.inRelations = rels;
            }
        }
        assert (rels != null);
        return rels.get((Object)def);
    }

    @Override
    public void resetCache() {
        this.name = null;
        this.definition = null;
        this.outRelations = null;
        this.inRelations = null;
    }

    public Iterable<TitanEdge> getEdges(TypeDefinitionCategory def, Direction dir) {
        return this.getEdges(def, dir, null);
    }

    public Iterable<TitanEdge> getEdges(final TypeDefinitionCategory def, Direction dir, TitanSchemaVertex other) {
        TitanVertexQuery query = (TitanVertexQuery)((VertexCentricQueryBuilder)this.query().type(BaseLabel.SchemaDefinitionEdge)).direction(dir);
        if (other != null) {
            query.adjacent(other);
        }
        return Iterables.filter(query.titanEdges(), (Predicate)new Predicate<TitanEdge>(){

            public boolean apply(@Nullable TitanEdge edge) {
                TypeDefinitionDescription desc = (TypeDefinitionDescription)edge.getProperty(BaseKey.SchemaDefinitionDesc);
                return desc.getCategory() == def;
            }
        });
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public SchemaStatus getStatus() {
        return this.getDefinition().getValue(TypeDefinitionCategory.STATUS, SchemaStatus.class);
    }

    @Override
    public IndexType asIndexType() {
        Preconditions.checkArgument((boolean)this.getDefinition().containsKey((Object)TypeDefinitionCategory.INTERNAL_INDEX), (String)"Schema vertex is not a type vertex: [%s,%s]", (Object[])new Object[]{this.getLongId(), this.getName()});
        if (((Boolean)this.getDefinition().getValue(TypeDefinitionCategory.INTERNAL_INDEX)).booleanValue()) {
            return new CompositeIndexTypeWrapper(this);
        }
        return new MixedIndexTypeWrapper(this);
    }
}

