/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.mockpolicies.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.powermock.mockpolicies.MockPolicyInterceptionSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPolicyInterceptionSettingsImpl
implements MockPolicyInterceptionSettings {
    private Set<Field> fieldsToSuppress = new LinkedHashSet<Field>();
    private Set<Method> methodsToSuppress = new LinkedHashSet<Method>();
    private Map<Method, Object> substituteReturnValues = new HashMap<Method, Object>();
    private Set<String> fieldsTypesToSuppress;
    private Map<Method, InvocationHandler> proxies = new HashMap<Method, InvocationHandler>();

    public MockPolicyInterceptionSettingsImpl() {
        this.fieldsTypesToSuppress = new LinkedHashSet<String>();
    }

    @Override
    public void addFieldTypesToSuppress(String firstType, String ... additionalFieldTypes) {
        this.fieldsTypesToSuppress.add(firstType);
        this.addFieldTypesToSuppress(additionalFieldTypes);
    }

    @Override
    public void addFieldTypesToSuppress(String[] fieldTypes) {
        for (String fieldType : fieldTypes) {
            this.fieldsTypesToSuppress.add(fieldType);
        }
    }

    @Override
    public void setFieldTypesToSuppress(String[] fieldTypes) {
        this.fieldsTypesToSuppress.clear();
        this.addFieldTypesToSuppress(fieldTypes);
    }

    @Override
    public Field[] getFieldsToSuppress() {
        return this.fieldsToSuppress.toArray(new Field[this.fieldsToSuppress.size()]);
    }

    @Override
    public Method[] getMethodsToSuppress() {
        return this.methodsToSuppress.toArray(new Method[this.methodsToSuppress.size()]);
    }

    @Override
    public Map<Method, Object> getStubbedMethods() {
        return Collections.unmodifiableMap(this.substituteReturnValues);
    }

    @Override
    public void addFieldToSuppress(Field firstField, Field ... fields) {
        this.fieldsToSuppress.add(firstField);
        this.addFieldToSuppress(fields);
    }

    @Override
    public void addFieldToSuppress(Field[] fields) {
        for (Field field : fields) {
            this.fieldsToSuppress.add(field);
        }
    }

    @Override
    public void addMethodsToSuppress(Method methodToSuppress, Method ... additionalMethodsToSuppress) {
        this.methodsToSuppress.add(methodToSuppress);
        this.addMethodsToSuppress(additionalMethodsToSuppress);
    }

    @Override
    public void addMethodsToSuppress(Method[] methods) {
        for (Method method : methods) {
            this.methodsToSuppress.add(method);
        }
    }

    @Override
    public void stubMethod(Method method, Object returnObject) {
        this.substituteReturnValues.put(method, returnObject);
    }

    @Override
    public void setFieldsSuppress(Field[] fields) {
        this.fieldsToSuppress.clear();
        this.addFieldToSuppress(fields);
    }

    @Override
    public void setMethodsToSuppress(Method[] methods) {
        this.methodsToSuppress.clear();
        this.addMethodsToSuppress(methods);
    }

    @Override
    public void setMethodsToStub(Map<Method, Object> substituteReturnValues) {
        this.substituteReturnValues = substituteReturnValues;
    }

    @Override
    public String[] getFieldTypesToSuppress() {
        return this.fieldsTypesToSuppress.toArray(new String[this.fieldsTypesToSuppress.size()]);
    }

    @Override
    public void addSubtituteReturnValue(Method method, Object returnObject) {
        this.substituteReturnValues.put(method, returnObject);
    }

    @Override
    public void setSubtituteReturnValues(Map<Method, Object> substituteReturnValues) {
        this.substituteReturnValues = substituteReturnValues;
    }

    @Override
    public Map<Method, Object> getSubstituteReturnValues() {
        return this.getStubbedMethods();
    }

    @Override
    public Map<Method, InvocationHandler> getProxiedMethods() {
        return this.proxies;
    }

    @Override
    public void proxyMethod(Method method, InvocationHandler invocationHandler) {
        this.proxies.put(method, invocationHandler);
    }

    @Override
    public void setMethodsToProxy(Map<Method, InvocationHandler> proxies) {
        this.proxies = proxies;
    }
}

