/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.sesametools.reposail;

import java.io.File;
import net.fortytwo.sesametools.reposail.RepositorySailConnection;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositorySail
extends SailBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositorySail.class);
    private Repository repository;
    private boolean inferenceDisabled = false;

    public RepositorySail(Repository repo) {
        this.repository = repo;
    }

    public void disableInference() {
        this.inferenceDisabled = true;
    }

    protected SailConnection getConnectionInternal() throws SailException {
        RepositoryConnection rc;
        try {
            rc = this.repository.getConnection();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
        return new RepositorySailConnection(this, rc, this.inferenceDisabled, this.getValueFactory());
    }

    public File getDataDir() {
        return this.repository.getDataDir();
    }

    public ValueFactory getValueFactory() {
        return this.repository.getValueFactory();
    }

    protected void initializeInternal() throws SailException {
        try {
            this.repository.initialize();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    public boolean isWritable() throws SailException {
        try {
            return this.repository.isWritable();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }

    public void setDataDir(File file) {
        this.repository.setDataDir(file);
    }

    protected void shutDownInternal() throws SailException {
        try {
            this.repository.shutDown();
        }
        catch (RepositoryException e) {
            throw new SailException((Throwable)e);
        }
    }
}

