/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mrunit.ReduceDriverBase;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.mapred.MockReporter;
import org.apache.hadoop.mrunit.internal.output.OutputCollectable;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.hadoop.util.ReflectionUtils;

public class ReduceDriver<K1, V1, K2, V2>
extends ReduceDriverBase<K1, V1, K2, V2, ReduceDriver<K1, V1, K2, V2>> {
    public static final Log LOG = LogFactory.getLog(ReduceDriver.class);
    private Reducer<K1, V1, K2, V2> myReducer;
    private Counters counters;

    public ReduceDriver(Reducer<K1, V1, K2, V2> r) {
        this();
        this.setReducer(r);
    }

    public ReduceDriver() {
        this.setCounters(new Counters());
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters ctrs) {
        this.counters = ctrs;
        this.counterWrapper = new CounterWrapper(ctrs);
    }

    public ReduceDriver<K1, V1, K2, V2> withCounters(Counters ctrs) {
        this.setCounters(ctrs);
        return this;
    }

    public void setReducer(Reducer<K1, V1, K2, V2> r) {
        this.myReducer = ArgumentChecker.returnNonNull(r);
    }

    public ReduceDriver<K1, V1, K2, V2> withReducer(Reducer<K1, V1, K2, V2> r) {
        this.setReducer(r);
        return this;
    }

    public Reducer<K1, V1, K2, V2> getReducer() {
        return this.myReducer;
    }

    public ReduceDriver<K1, V1, K2, V2> withOutputFormat(Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass) {
        this.mockOutputCreator.setMapredFormats(outputFormatClass, inputFormatClass);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<K2, V2>> run() throws IOException {
        try {
            this.preRunChecks(this.myReducer);
            this.initDistributedCache();
            OutputCollectable outputCollectable = this.mockOutputCreator.createMapredOutputCollectable(this.getConfiguration(), this.getOutputSerializationConfiguration());
            MockReporter reporter = new MockReporter(MockReporter.ReporterType.Reducer, this.getCounters());
            ReflectionUtils.setConf(this.myReducer, (Configuration)new JobConf(this.getConfiguration()));
            for (Pair kv : this.inputs) {
                this.myReducer.reduce(kv.getFirst(), ((List)kv.getSecond()).iterator(), outputCollectable, (Reporter)reporter);
            }
            this.myReducer.close();
            List<Pair<K2, V2>> list = outputCollectable.getOutputs();
            return list;
        }
        finally {
            this.cleanupDistributedCache();
        }
    }

    public String toString() {
        return "ReduceDriver (" + this.myReducer + ")";
    }

    public static <K1, V1, K2, V2> ReduceDriver<K1, V1, K2, V2> newReduceDriver() {
        return new ReduceDriver<K1, V1, K2, V2>();
    }

    public static <K1, V1, K2, V2> ReduceDriver<K1, V1, K2, V2> newReduceDriver(Reducer<K1, V1, K2, V2> reducer) {
        return new ReduceDriver<K1, V1, K2, V2>(reducer);
    }
}

