/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.util.Threads;

public class JVMClusterUtil {
    private static final Log LOG = LogFactory.getLog(JVMClusterUtil.class);

    public static RegionServerThread createRegionServerThread(Configuration c, Class<? extends HRegionServer> hrsc, int index) throws IOException {
        HRegionServer server;
        try {
            server = hrsc.getConstructor(Configuration.class).newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of RegionServer: " + hrsc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return new RegionServerThread(server, index);
    }

    public static MasterThread createMasterThread(Configuration c, Class<? extends HMaster> hmc, int index) throws IOException {
        HMaster server;
        try {
            server = hmc.getConstructor(Configuration.class).newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of Master: " + hmc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return new MasterThread(server, index);
    }

    private static MasterThread findActiveMaster(List<MasterThread> masters) {
        for (MasterThread t : masters) {
            if (!t.master.isActiveMaster()) continue;
            return t;
        }
        return null;
    }

    public static String startup(List<MasterThread> masters, List<RegionServerThread> regionservers) throws IOException {
        if (masters == null || masters.isEmpty()) {
            return null;
        }
        for (MasterThread t : masters) {
            t.start();
        }
        long startTime = System.currentTimeMillis();
        while (JVMClusterUtil.findActiveMaster(masters) == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= startTime + 30000L) continue;
            throw new RuntimeException("Master not active after 30 seconds");
        }
        if (regionservers != null) {
            for (RegionServerThread t : regionservers) {
                HRegionServer hrs = t.getRegionServer();
                ShutdownHook.install(hrs.getConfiguration(), FileSystem.get((Configuration)hrs.getConfiguration()), hrs, t);
                t.start();
            }
        }
        startTime = System.currentTimeMillis();
        MasterThread t;
        while ((t = JVMClusterUtil.findActiveMaster(masters)) == null || !t.master.isInitialized()) {
            if (System.currentTimeMillis() > startTime + 200000L) {
                throw new RuntimeException("Master not initialized after 200 seconds");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {
            }
        }
        return t.master.getServerName().toString();
    }

    public static void shutdown(List<MasterThread> masters, List<RegionServerThread> regionservers) {
        LOG.debug((Object)"Shutting down HBase Cluster");
        if (masters != null) {
            MasterThread activeMaster = null;
            for (MasterThread t : masters) {
                if (!t.master.isActiveMaster()) {
                    t.master.stopMaster();
                    continue;
                }
                activeMaster = t;
            }
            if (activeMaster != null) {
                activeMaster.master.shutdown();
            }
        }
        for (RegionServerThread regionServerThread : regionservers) {
            if (!regionServerThread.isAlive()) continue;
            try {
                regionServerThread.getRegionServer().stop("Shutdown requested");
                regionServerThread.join();
            }
            catch (InterruptedException e) {}
        }
        if (masters != null) {
            for (MasterThread masterThread : masters) {
                while (masterThread.master.isAlive()) {
                    try {
                        Threads.threadDumpingIsAlive(masterThread.master.getThread());
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        LOG.info((Object)("Shutdown of " + (masters != null ? Integer.valueOf(masters.size()) : "0") + " master(s) and " + (regionservers != null ? Integer.valueOf(regionservers.size()) : "0") + " regionserver(s) complete"));
    }

    public static class MasterThread
    extends Thread {
        private final HMaster master;

        public MasterThread(HMaster m, int index) {
            super((Runnable)m, "Master:" + index + ";" + m.getServerName());
            this.master = m;
        }

        public HMaster getMaster() {
            return this.master;
        }
    }

    public static class RegionServerThread
    extends Thread {
        private final HRegionServer regionServer;

        public RegionServerThread(HRegionServer r, int index) {
            super((Runnable)r, "RegionServer:" + index + ";" + r.getServerName());
            this.regionServer = r;
        }

        public HRegionServer getRegionServer() {
            return this.regionServer;
        }

        public void waitForServerOnline() {
            this.regionServer.waitForServerOnline();
        }
    }
}

