/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ZKTableReadOnly {
    private ZKTableReadOnly() {
    }

    public static boolean isDisabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        ZKTable.TableState state = ZKTableReadOnly.getTableState(zkw, tableName);
        return ZKTableReadOnly.isTableState(ZKTable.TableState.DISABLED, state);
    }

    public static boolean isEnabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        ZKTable.TableState state = ZKTableReadOnly.getTableState(zkw, tableName);
        return state == null || state == ZKTable.TableState.ENABLED;
    }

    public static boolean isDisablingOrDisabledTable(ZooKeeperWatcher zkw, String tableName) throws KeeperException {
        ZKTable.TableState state = ZKTableReadOnly.getTableState(zkw, tableName);
        return ZKTableReadOnly.isTableState(ZKTable.TableState.DISABLING, state) || ZKTableReadOnly.isTableState(ZKTable.TableState.DISABLED, state);
    }

    public static Set<String> getDisabledTables(ZooKeeperWatcher zkw) throws KeeperException {
        HashSet<String> disabledTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.clientTableZNode);
        for (String child : children) {
            ZKTable.TableState state = ZKTableReadOnly.getTableState(zkw, child);
            if (state != ZKTable.TableState.DISABLED) continue;
            disabledTables.add(child);
        }
        return disabledTables;
    }

    public static Set<String> getDisabledOrDisablingTables(ZooKeeperWatcher zkw) throws KeeperException {
        HashSet<String> disabledTables = new HashSet<String>();
        List<String> children = ZKUtil.listChildrenNoWatch(zkw, zkw.clientTableZNode);
        for (String child : children) {
            ZKTable.TableState state = ZKTableReadOnly.getTableState(zkw, child);
            if (state != ZKTable.TableState.DISABLED && state != ZKTable.TableState.DISABLING) continue;
            disabledTables.add(child);
        }
        return disabledTables;
    }

    static boolean isTableState(ZKTable.TableState expectedState, ZKTable.TableState currentState) {
        return currentState != null && currentState.equals((Object)expectedState);
    }

    static ZKTable.TableState getTableState(ZooKeeperWatcher zkw, String child) throws KeeperException {
        return ZKTableReadOnly.getTableState(zkw, zkw.clientTableZNode, child);
    }

    static ZKTable.TableState getTableState(ZooKeeperWatcher zkw, String parent, String child) throws KeeperException {
        String znode = ZKUtil.joinZNode(parent, child);
        byte[] data = ZKUtil.getData(zkw, znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        String str = Bytes.toString(data);
        try {
            return ZKTable.TableState.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(str);
        }
    }
}

