/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow;

import java.util.Iterator;
import net.fortytwo.flow.SimpleReadOnlyCollection;
import net.fortytwo.flow.Sink;
import net.fortytwo.flow.Source;
import net.fortytwo.ripple.RippleException;

public class Collector<T>
extends SimpleReadOnlyCollection<T>
implements Sink<T>,
Source<T> {
    private Node first;
    private Node last;
    private int count;

    public Collector() {
        this.clear();
    }

    @Override
    public void put(T t) throws RippleException {
        Node n = new Node(t, null);
        if (null == this.first) {
            this.first = n;
        } else {
            this.last.next = n;
        }
        this.last = n;
        ++this.count;
    }

    @Override
    public void writeTo(Sink<T> sink) throws RippleException {
        Node cur = this.first;
        while (null != cur) {
            try {
                sink.put(cur.value);
            }
            catch (RippleException e) {
                e.printStackTrace();
            }
            cur = cur.next;
        }
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public Iterator<T> iterator() {
        return new NodeIterator(this.first);
    }

    @Override
    public void clear() {
        this.first = null;
        this.count = 0;
    }

    private class NodeIterator
    implements Iterator<T> {
        private Node cur;

        public NodeIterator(Node first) {
            this.cur = first;
        }

        @Override
        public boolean hasNext() {
            return null != this.cur;
        }

        @Override
        public T next() {
            Object value = this.cur.value;
            this.cur = this.cur.next;
            return value;
        }

        @Override
        public void remove() {
        }
    }

    private class Node {
        public T value;
        public Node next;

        public Node(T value, Node next) {
            this.value = value;
            this.next = next;
        }
    }
}

