/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist.rdf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.edgelist.rdf.Crc64;
import com.thinkaurelius.titan.hadoop.formats.edgelist.rdf.RDFConfig;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class RDFBlueprintsHandler
implements RDFHandler,
Iterator<FaunusElement> {
    private static final Logger logger = Logger.getLogger(RDFBlueprintsHandler.class);
    private final boolean useFragments;
    private final ModifiableHadoopConfiguration faunusConf;
    private final Configuration rdfConf;
    private final Set<String> asProperties = new HashSet<String>();
    private final boolean literalAsProperty;
    private final RDFParser parser;
    private final Queue<FaunusElement> queue = new LinkedList<FaunusElement>();
    private final String baseURI;
    private final Set<String> reservedFragments = new HashSet<String>();
    private static ImmutableMap<String, Character> dataTypeToClass;
    private static final char STRING = 's';
    private static final char INTEGER = 'i';
    private static final char FLOAT = 'f';
    private static final char DOUBLE = 'd';
    private static final char LONG = 'l';
    private static final char BOOLEAN = 'b';

    public RDFBlueprintsHandler(ModifiableHadoopConfiguration configuration) throws IOException {
        this.reservedFragments.add("label");
        this.reservedFragments.add("id");
        this.faunusConf = configuration;
        this.rdfConf = this.faunusConf.getInputConf(RDFConfig.ROOT_NS);
        this.baseURI = (String)this.rdfConf.get(RDFConfig.RDF_BASE_URI, new String[0]);
        this.useFragments = (Boolean)this.rdfConf.get(RDFConfig.RDF_USE_LOCALNAME, new String[0]);
        this.literalAsProperty = (Boolean)this.rdfConf.get(RDFConfig.RDF_LITERAL_AS_PROPERTY, new String[0]);
        for (String property : (String[])this.rdfConf.get(RDFConfig.RDF_AS_PROPERTIES, new String[0])) {
            this.asProperties.add(property.trim());
        }
        if (!this.rdfConf.has(RDFConfig.RDF_FORMAT, new String[0])) {
            throw new RuntimeException("RDF format is required.  Set " + ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.INPUT_CONF_NS, (String[])new String[0]) + "." + RDFConfig.RDF_FORMAT.getName());
        }
        RDFConfig.Syntax syntax = (RDFConfig.Syntax)((Object)this.rdfConf.get(RDFConfig.RDF_FORMAT, new String[0]));
        RDFFormat format = syntax.getRDFFormat();
        Preconditions.checkNotNull((Object)format);
        this.parser = Rio.createParser((RDFFormat)format);
        this.parser.setRDFHandler((RDFHandler)this);
        this.parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
    }

    public void startRDF() throws RDFHandlerException {
    }

    public void endRDF() throws RDFHandlerException {
    }

    public void handleNamespace(String s, String s1) throws RDFHandlerException {
    }

    public String postProcess(Value resource) {
        if (resource instanceof URI) {
            if (this.useFragments) {
                return this.createFragment(resource);
            }
            return resource.stringValue();
        }
        return resource.stringValue();
    }

    private String createFragment(Value resource) {
        if (resource instanceof URI) {
            String frag = ((URI)resource).getLocalName();
            return this.reservedFragments.contains(frag) ? frag + "_" : frag;
        }
        return resource.stringValue();
    }

    private static Object castLiteral(Literal literal) {
        if (null != literal.getDatatype()) {
            Character type = (Character)dataTypeToClass.get((Object)literal.getDatatype().stringValue());
            if (null == type) {
                return literal.getLabel();
            }
            if ('s' == type.charValue()) {
                return literal.getLabel();
            }
            if ('f' == type.charValue()) {
                return Float.valueOf(literal.getLabel());
            }
            if ('i' == type.charValue()) {
                return Integer.valueOf(literal.getLabel());
            }
            if ('d' == type.charValue()) {
                return Double.valueOf(literal.getLabel());
            }
            if ('l' == type.charValue()) {
                return Long.valueOf(literal.getLabel());
            }
            if ('b' == type.charValue()) {
                return Boolean.valueOf(literal.getLabel());
            }
            return literal.getLabel();
        }
        return literal.getLabel();
    }

    public void handleStatement(Statement s) throws RDFHandlerException {
        if (this.asProperties.contains(s.getPredicate().toString())) {
            FaunusVertex subject = new FaunusVertex((Configuration)this.faunusConf, Crc64.digest(s.getSubject().stringValue().getBytes()));
            subject.setProperty(this.postProcess((Value)s.getPredicate()), (Object)this.postProcess(s.getObject()));
            subject.setProperty("uri", (Object)s.getSubject().stringValue());
            if (this.useFragments) {
                subject.setProperty("name", (Object)this.createFragment((Value)s.getSubject()));
            }
            this.queue.add(subject);
        } else if (this.literalAsProperty && s.getObject() instanceof Literal) {
            FaunusVertex subject = new FaunusVertex((Configuration)this.faunusConf, Crc64.digest(s.getSubject().stringValue().getBytes()));
            subject.setProperty(this.postProcess((Value)s.getPredicate()), RDFBlueprintsHandler.castLiteral((Literal)s.getObject()));
            subject.setProperty("uri", (Object)s.getSubject().stringValue());
            if (this.useFragments) {
                subject.setProperty("name", (Object)this.createFragment((Value)s.getSubject()));
            }
            this.queue.add(subject);
        } else {
            long subjectId = Crc64.digest(s.getSubject().stringValue().getBytes());
            FaunusVertex subject = new FaunusVertex((Configuration)this.faunusConf, subjectId);
            subject.setProperty("uri", (Object)s.getSubject().stringValue());
            if (this.useFragments) {
                subject.setProperty("name", (Object)this.createFragment((Value)s.getSubject()));
            }
            this.queue.add(subject);
            long objectId = Crc64.digest(s.getObject().stringValue().getBytes());
            FaunusVertex object = new FaunusVertex((Configuration)this.faunusConf, objectId);
            object.setProperty("uri", (Object)s.getObject().stringValue());
            if (this.useFragments) {
                object.setProperty("name", (Object)this.createFragment(s.getObject()));
            }
            this.queue.add(object);
            StandardFaunusEdge predicate = new StandardFaunusEdge((Configuration)this.faunusConf, -1L, subjectId, objectId, this.postProcess((Value)s.getPredicate()));
            predicate.setProperty("uri", (Object)s.getPredicate().stringValue());
            if (null != s.getContext()) {
                predicate.setProperty("context", (Object)s.getContext().stringValue());
            }
            this.queue.add(predicate);
        }
    }

    public void handleComment(String s) throws RDFHandlerException {
    }

    public boolean parse(String string) throws IOException {
        if (null == string) {
            return false;
        }
        try {
            this.parser.parse((Reader)new StringReader(string), this.baseURI);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public FaunusElement next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.remove();
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        b.put((Object)"http://www.w3.org/2001/XMLSchema#string", (Object)Character.valueOf('s'));
        b.put((Object)"http://www.w3.org/2001/XMLSchema#int", (Object)Character.valueOf('i'));
        b.put((Object)"http://www.w3.org/2001/XMLSchema#integer", (Object)Character.valueOf('i'));
        b.put((Object)"http://www.w3.org/2001/XMLSchema#float", (Object)Character.valueOf('f'));
        b.put((Object)"http://www.w3.org/2001/XMLSchema#double", (Object)Character.valueOf('d'));
        b.put((Object)"http://www.w3.org/2001/XMLSchema#long", (Object)Character.valueOf('l'));
        b.put((Object)"http://www.w3.org/2001/XMLSchema#boolean", (Object)Character.valueOf('b'));
        dataTypeToClass = b.build();
    }
}

