/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.graphdb.schema.SchemaContainer;
import com.thinkaurelius.titan.graphdb.schema.SchemaProvider;
import com.thinkaurelius.titan.hadoop.FaunusSchemaManager;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import java.io.IOException;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanSchemaAwareMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private static final Logger log = LoggerFactory.getLogger(TitanSchemaAwareMapper.class);

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        try {
            ModifiableHadoopConfiguration faunusConf = ModifiableHadoopConfiguration.of(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context));
            if (faunusConf.get(TitanHadoopConfiguration.OUTPUT_TITAN_TYPE_CHECKING, new String[0]).booleanValue()) {
                TitanGraph g = TitanFactory.open((BasicConfiguration)faunusConf.getOutputConf());
                FaunusSchemaManager.getTypeManager(null).setSchemaProvider((SchemaProvider)new SchemaContainer(g));
                log.info("Loaded schema associated with {}", (Object)g);
            } else {
                log.debug("Titan schema checking is disabled");
            }
        }
        catch (Throwable t) {
            log.warn("Unable to load Titan schema", t);
        }
    }
}

