/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.CollationController;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIteratorFactory;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.ExtendedFilter;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.StreamLockfile;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.DefaultInteger;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.Interval;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    public static final ExecutorService postFlushExecutor = new JMXEnabledThreadPoolExecutor("MemtablePostFlusher");
    public final Keyspace keyspace;
    public final String name;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    private final String mbeanName;
    private volatile boolean valid = true;
    private final DataTracker data;
    private final AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    public final SecondaryIndexManager indexManager;
    private static final int INTERN_CUTOFF = 256;
    public final ConcurrentMap<ByteBuffer, ByteBuffer> internedNames = new NonBlockingHashMap();
    private volatile DefaultInteger minCompactionThreshold;
    private volatile DefaultInteger maxCompactionThreshold;
    private volatile AbstractCompactionStrategy compactionStrategy;
    public final Directories directories;
    public final ColumnFamilyMetrics metric;
    public volatile long sampleLatencyNanos;

    public void reload() {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultInteger(this.metadata.getMinCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultInteger(this.metadata.getMaxCompactionThreshold());
            }
        }
        this.maybeReloadCompactionStrategy();
        this.scheduleFlush();
        this.indexManager.reload();
        if (this.getMemtableThreadSafe().initialComparator != this.metadata.comparator) {
            this.switchMemtable(true, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadCompactionStrategy() {
        if (this.metadata.compactionStrategyClass.equals(this.compactionStrategy.getClass()) && this.metadata.compactionStrategyOptions.equals(this.compactionStrategy.options)) {
            return;
        }
        ColumnFamilyStore columnFamilyStore = this;
        synchronized (columnFamilyStore) {
            this.compactionStrategy.shutdown();
            this.compactionStrategy = this.metadata.createCompactionStrategyInstance(this);
            this.compactionStrategy.startup();
        }
    }

    void scheduleFlush() {
        int period = this.metadata.getMemtableFlushPeriod();
        if (period > 0) {
            logger.debug("scheduling flush in {} ms", (Object)period);
            WrappedRunnable runnable = new WrappedRunnable(){

                @Override
                protected void runMayThrow() throws Exception {
                    if (ColumnFamilyStore.this.getMemtableThreadSafe().isExpired()) {
                        if (ColumnFamilyStore.this.isClean()) {
                            ColumnFamilyStore.this.scheduleFlush();
                        } else {
                            ColumnFamilyStore.this.forceFlush();
                        }
                    }
                }
            };
            StorageService.scheduledTasks.schedule(runnable, (long)period, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void setCompactionStrategyClass(String compactionStrategyClass) {
        try {
            this.metadata.compactionStrategyClass = CFMetaData.createCompactionStrategy(compactionStrategyClass);
            this.maybeReloadCompactionStrategy();
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public String getCompactionStrategyClass() {
        return this.metadata.compactionStrategyClass.getName();
    }

    @Override
    public Map<String, String> getCompressionParameters() {
        return this.metadata.compressionParameters().asThriftOptions();
    }

    @Override
    public void setCompressionParameters(Map<String, String> opts) {
        try {
            this.metadata.compressionParameters = CompressionParameters.create(opts);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void setCrcCheckChance(double crcCheckChance) {
        try {
            for (SSTableReader sstable : this.keyspace.getAllSSTables()) {
                if (!sstable.compression) continue;
                sstable.getCompressionMetadata().parameters.setCrcCheckChance(crcCheckChance);
            }
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private ColumnFamilyStore(Keyspace keyspace, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata, Directories directories, boolean loadSSTables) {
        assert (metadata != null) : "null metadata for " + keyspace + ":" + columnFamilyName;
        this.keyspace = keyspace;
        this.name = columnFamilyName;
        this.metadata = metadata;
        this.minCompactionThreshold = new DefaultInteger(metadata.getMinCompactionThreshold());
        this.maxCompactionThreshold = new DefaultInteger(metadata.getMaxCompactionThreshold());
        this.partitioner = partitioner;
        this.directories = directories;
        this.indexManager = new SecondaryIndexManager(this);
        this.metric = new ColumnFamilyMetrics(this);
        this.fileIndexGenerator.set(generation);
        this.sampleLatencyNanos = DatabaseDescriptor.getReadRpcTimeout() / 2L;
        CFMetaData.Caching caching = metadata.getCaching();
        logger.info("Initializing {}.{}", (Object)keyspace.getName(), (Object)this.name);
        this.data = new DataTracker(this);
        if (loadSSTables) {
            Directories.SSTableLister sstableFiles = directories.sstableLister().skipTemporary(true);
            Collection<SSTableReader> sstables = SSTableReader.openAll(sstableFiles.list().entrySet(), metadata, this.partitioner);
            this.data.addInitialSSTables(sstables);
        }
        if (caching == CFMetaData.Caching.ALL || caching == CFMetaData.Caching.KEYS_ONLY) {
            CacheService.instance.keyCache.loadSaved(this);
        }
        this.compactionStrategy = metadata.createCompactionStrategyInstance(this);
        this.compactionStrategy.startup();
        if (this.maxCompactionThreshold.value() <= 0 || this.minCompactionThreshold.value() <= 0) {
            logger.warn("Disabling compaction strategy by setting compaction thresholds to 0 is deprecated, set the compaction option 'enabled' to 'false' instead.");
            this.compactionStrategy.disable();
        }
        for (ColumnDefinition info : metadata.allColumns()) {
            if (info.getIndexType() == null) continue;
            this.indexManager.addIndexedColumn(info);
        }
        String type = this.partitioner instanceof LocalPartitioner ? "IndexColumnFamilies" : "ColumnFamilies";
        this.mbeanName = "org.apache.cassandra.db:type=" + type + ",keyspace=" + this.keyspace.getName() + ",columnfamily=" + this.name;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, nameObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        logger.debug("retryPolicy for {} is {}", (Object)this.name, (Object)this.metadata.getSpeculativeRetry());
        StorageService.optionalTasks.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CFMetaData.SpeculativeRetry retryPolicy = ColumnFamilyStore.this.metadata.getSpeculativeRetry();
                switch (retryPolicy.type) {
                    case PERCENTILE: {
                        assert (ColumnFamilyStore.this.metric.coordinatorReadLatency.durationUnit() == TimeUnit.MICROSECONDS);
                        ColumnFamilyStore.this.sampleLatencyNanos = (long)(ColumnFamilyStore.this.metric.coordinatorReadLatency.getSnapshot().getValue(retryPolicy.value) * 1000.0);
                        break;
                    }
                    case CUSTOM: {
                        ColumnFamilyStore.this.sampleLatencyNanos = (long)(retryPolicy.value * 1000.0 * 1000.0);
                        break;
                    }
                    default: {
                        ColumnFamilyStore.this.sampleLatencyNanos = Long.MAX_VALUE;
                    }
                }
            }
        }, DatabaseDescriptor.getReadRpcTimeout(), DatabaseDescriptor.getReadRpcTimeout(), TimeUnit.MILLISECONDS);
    }

    public void invalidate() {
        this.valid = false;
        try {
            this.unregisterMBean();
        }
        catch (Exception e) {
            logger.warn("Failed unregistering mbean: " + this.mbeanName, (Throwable)e);
        }
        this.compactionStrategy.shutdown();
        SystemKeyspace.removeTruncationRecord(this.metadata.cfId);
        this.data.unreferenceSSTables();
        this.indexManager.invalidate();
        for (RowCacheKey key : CacheService.instance.rowCache.getKeySet()) {
            if (key.cfId != this.metadata.cfId) continue;
            this.invalidateCachedRow(key);
        }
        String ksname = this.keyspace.getName();
        for (KeyCacheKey key : CacheService.instance.keyCache.getKeySet()) {
            if (!((String)key.getPathInfo().left).equals(ksname) || !((String)key.getPathInfo().right).equals(this.name)) continue;
            CacheService.instance.keyCache.remove(key);
        }
    }

    void maybeRemoveUnreadableSSTables(File directory) {
        this.data.removeUnreadableSSTables(directory);
    }

    void unregisterMBean() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName nameObj;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(nameObj = new ObjectName(this.mbeanName))) {
            mbs.unregisterMBean(nameObj);
        }
        this.metric.release();
    }

    @Override
    public long getMinRowSize() {
        return (Long)this.metric.minRowSize.value();
    }

    @Override
    public long getMaxRowSize() {
        return (Long)this.metric.maxRowSize.value();
    }

    @Override
    public long getMeanRowSize() {
        return (Long)this.metric.meanRowSize.value();
    }

    public int getMeanColumns() {
        return this.data.getMeanColumns();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, boolean loadSSTables) {
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, columnFamily, StorageService.getPartitioner(), Schema.instance.getCFMetaData(keyspace.getName(), columnFamily), loadSSTables);
    }

    public static ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, IPartitioner partitioner, CFMetaData metadata) {
        return ColumnFamilyStore.createColumnFamilyStore(keyspace, columnFamily, partitioner, metadata, true);
    }

    private static synchronized ColumnFamilyStore createColumnFamilyStore(Keyspace keyspace, String columnFamily, IPartitioner partitioner, CFMetaData metadata, boolean loadSSTables) {
        Directories directories = Directories.create(keyspace.getName(), columnFamily);
        Directories.SSTableLister lister = directories.sstableLister().includeBackups(true);
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            Descriptor desc = entry.getKey();
            generations.add(desc.generation);
            if (desc.isCompatible()) continue;
            throw new RuntimeException(String.format("Incompatible SSTable found.  Current version %s is unable to read file: %s.  Please run upgradesstables.", Descriptor.Version.CURRENT, desc));
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(keyspace, columnFamily, partitioner, value, metadata, directories, loadSSTables);
    }

    public static void scrubDataDirectories(String keyspaceName, String columnFamily) {
        CFMetaData cfm;
        Directories directories = Directories.create(keyspaceName, columnFamily);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.toString().endsWith(".lockfile");
            }
        };
        for (File file : directories.getCFDirectories()) {
            File[] lockfiles = file.listFiles(filter);
            if (lockfiles == null || lockfiles.length == 0) continue;
            logger.info("Removing SSTables from failed streaming session. Found {} files to cleanup.", (Object)lockfiles.length);
            for (File lockfile : lockfiles) {
                StreamLockfile streamLockfile = new StreamLockfile(lockfile);
                streamLockfile.cleanup();
                streamLockfile.delete();
            }
        }
        logger.debug("Removing compacted SSTable files from {} (see http://wiki.apache.org/cassandra/MemtableSSTable)", (Object)columnFamily);
        for (Map.Entry entry : directories.sstableLister().list().entrySet()) {
            Descriptor desc = (Descriptor)entry.getKey();
            Set components = (Set)entry.getValue();
            if (components.contains(Component.COMPACTED_MARKER) || desc.temporary) {
                SSTable.delete(desc, components);
                continue;
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, (Object)components);
            for (Component component : components) {
                FileUtils.deleteWithConfirm(desc.filenameFor(component));
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(keyspaceName + "-" + columnFamily + "-(Key|Row)Cache.*\\.tmp$");
        File file = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (file.exists()) {
            assert (file.isDirectory());
            for (File file2 : file.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file2.getName()).matches() || file2.delete()) continue;
                logger.warn("could not delete " + file2.getAbsolutePath());
            }
        }
        if ((cfm = Schema.instance.getCFMetaData(keyspaceName, columnFamily)) != null) {
            for (ColumnDefinition def : cfm.allColumns()) {
                ColumnFamilyStore.scrubDataDirectories(keyspaceName, cfm.indexColumnFamilyName(def));
            }
        }
    }

    public static void removeUnfinishedCompactionLeftovers(String keyspace, String columnfamily, Map<Integer, UUID> unfinishedCompactions) {
        Descriptor desc;
        Directories directories = Directories.create(keyspace, columnfamily);
        HashSet<Integer> allGenerations = new HashSet<Integer>();
        for (Descriptor desc2 : directories.sstableLister().list().keySet()) {
            allGenerations.add(desc2.generation);
        }
        Set<Integer> unfinishedGenerations = unfinishedCompactions.keySet();
        if (!allGenerations.containsAll(unfinishedGenerations)) {
            HashSet<Integer> missingGenerations = new HashSet<Integer>(unfinishedGenerations);
            missingGenerations.removeAll(allGenerations);
            logger.debug("Unfinished compactions of {}.{} reference missing sstables of generations {}", new Object[]{keyspace, columnfamily, missingGenerations});
        }
        HashSet completedAncestors = new HashSet();
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister().list().entrySet()) {
            Set ancestors;
            desc = sstableFiles.getKey();
            try {
                ancestors = (Set)SSTableMetadata.serializer.deserialize((Descriptor)desc).right;
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, desc.filenameFor(Component.STATS));
            }
            if (!ancestors.isEmpty() && unfinishedGenerations.containsAll(ancestors) && allGenerations.containsAll(ancestors)) {
                UUID compactionTaskID = unfinishedCompactions.get(ancestors.iterator().next());
                assert (compactionTaskID != null);
                logger.debug("Going to delete unfinished compaction product {}", (Object)desc);
                SSTable.delete(desc, sstableFiles.getValue());
                SystemKeyspace.finishCompaction(compactionTaskID);
                continue;
            }
            completedAncestors.addAll(ancestors);
        }
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : directories.sstableLister().list().entrySet()) {
            desc = sstableFiles.getKey();
            if (!completedAncestors.contains(desc.generation)) continue;
            logger.debug("Going to delete leftover compaction ancestor {}", (Object)desc);
            SSTable.delete(desc, sstableFiles.getValue());
            UUID compactionTaskID = unfinishedCompactions.get(desc.generation);
            if (compactionTaskID == null) continue;
            SystemKeyspace.finishCompaction(unfinishedCompactions.get(desc.generation));
        }
    }

    public void initRowCache() {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        long start = System.nanoTime();
        int cachedRowsRead = CacheService.instance.rowCache.loadSaved(this);
        if (cachedRowsRead > 0) {
            logger.info("completed loading ({} ms; {} keys) row cache for {}.{}", new Object[]{TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start), cachedRowsRead, this.keyspace.getName(), this.name});
        }
    }

    public static synchronized void loadNewSSTables(String ksName, String cfName) {
        Keyspace keyspace = Keyspace.open(ksName);
        keyspace.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void loadNewSSTables() {
        logger.info("Loading new SSTables for " + this.keyspace.getName() + "/" + this.name + "...");
        HashSet<Descriptor> currentDescriptors = new HashSet<Descriptor>();
        for (SSTableReader sstable : this.data.getView().sstables) {
            currentDescriptors.add(sstable.descriptor);
        }
        HashSet<SSTableReader> newSSTables = new HashSet<SSTableReader>();
        Directories.SSTableLister lister = this.directories.sstableLister().skipTemporary(true);
        for (Map.Entry<Descriptor, Set<Component>> entry : lister.list().entrySet()) {
            SSTableReader reader;
            Descriptor newDescriptor;
            Descriptor descriptor;
            block12: {
                descriptor = entry.getKey();
                if (currentDescriptors.contains(descriptor) || descriptor.temporary) continue;
                if (!descriptor.isCompatible()) {
                    throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", Descriptor.Version.CURRENT, descriptor));
                }
                try {
                    if (!new File(descriptor.filenameFor(Component.STATS)).exists()) break block12;
                    Pair<SSTableMetadata, Set<Integer>> oldMetadata = SSTableMetadata.serializer.deserialize(descriptor);
                    LeveledManifest.mutateLevel(oldMetadata, descriptor, descriptor.filenameFor(Component.STATS), 0);
                }
                catch (IOException e) {
                    SSTableReader.logOpenException(entry.getKey(), e);
                    continue;
                }
            }
            while (new File((newDescriptor = new Descriptor(descriptor.version, descriptor.directory, descriptor.ksname, descriptor.cfname, this.fileIndexGenerator.incrementAndGet(), false)).filenameFor(Component.DATA)).exists()) {
            }
            logger.info("Renaming new SSTable {} to {}", (Object)descriptor, (Object)newDescriptor);
            SSTableWriter.rename(descriptor, newDescriptor, entry.getValue());
            try {
                reader = SSTableReader.open(newDescriptor, entry.getValue(), this.metadata, this.partitioner);
            }
            catch (IOException e) {
                SSTableReader.logOpenException(entry.getKey(), e);
                continue;
            }
            newSSTables.add(reader);
        }
        if (newSSTables.isEmpty()) {
            logger.info("No new SSTables were found for " + this.keyspace.getName() + "/" + this.name);
            return;
        }
        logger.info("Loading new SSTables and building secondary indexes for " + this.keyspace.getName() + "/" + this.name + ": " + newSSTables);
        SSTableReader.acquireReferences(newSSTables);
        this.data.addSSTables(newSSTables);
        try {
            this.indexManager.maybeBuildSecondaryIndexes(newSSTables, this.indexManager.allIndexesNames());
        }
        finally {
            SSTableReader.releaseReferences(newSSTables);
        }
        logger.info("Done loading load new SSTables for " + this.keyspace.getName() + "/" + this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuildSecondaryIndex(String ksName, String cfName, String ... idxNames) {
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(cfName);
        HashSet<String> indexes = new HashSet<String>(Arrays.asList(idxNames));
        Collection<SSTableReader> sstables = cfs.getSSTables();
        try {
            cfs.indexManager.setIndexRemoved(indexes);
            SSTableReader.acquireReferences(sstables);
            logger.info(String.format("User Requested secondary index re-build for %s/%s indexes", ksName, cfName));
            cfs.indexManager.maybeBuildSecondaryIndexes(sstables, indexes);
            cfs.indexManager.setIndexBuilt(indexes);
        }
        finally {
            SSTableReader.releaseReferences(sstables);
        }
    }

    @Override
    public String getColumnFamilyName() {
        return this.name;
    }

    public String getTempSSTablePath(File directory) {
        return this.getTempSSTablePath(directory, Descriptor.Version.CURRENT);
    }

    private String getTempSSTablePath(File directory, Descriptor.Version version) {
        Descriptor desc = new Descriptor(version, directory, this.keyspace.getName(), this.name, this.fileIndexGenerator.incrementAndGet(), true);
        return desc.filenameFor(Component.DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> switchMemtable(final boolean writeCommitLog, boolean forceSwitch) {
        Keyspace.switchLock.writeLock().lock();
        try {
            ListenableFuture ctx = writeCommitLog ? CommitLog.instance.getContext() : Futures.immediateFuture((Object)ReplayPosition.NONE);
            final ArrayList<ColumnFamilyStore> icc = new ArrayList<ColumnFamilyStore>();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                if (!forceSwitch && cfs.getMemtableThreadSafe().isClean()) continue;
                icc.add(cfs);
            }
            final CountDownLatch latch = new CountDownLatch(icc.size());
            for (ColumnFamilyStore cfs : icc) {
                Memtable memtable = cfs.data.switchMemtable();
                if (memtable.isClean()) {
                    cfs.replaceFlushed(memtable, null);
                    latch.countDown();
                    continue;
                }
                logger.info("Enqueuing flush of {}", (Object)memtable);
                memtable.flushAndSignal(latch, (Future<ReplayPosition>)ctx);
            }
            if (this.metric.memtableSwitchCount.count() == Long.MAX_VALUE) {
                this.metric.memtableSwitchCount.clear();
            }
            this.metric.memtableSwitchCount.inc();
            Future<?> future = postFlushExecutor.submit(new WrappedRunnable((Future)ctx){
                final /* synthetic */ Future val$ctx;
                {
                    this.val$ctx = future;
                }

                @Override
                public void runMayThrow() throws InterruptedException, ExecutionException {
                    latch.await();
                    if (!icc.isEmpty()) {
                        for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexesNotBackedByCfs()) {
                            logger.info("Flushing SecondaryIndex {}", (Object)index);
                            index.forceBlockingFlush();
                        }
                    }
                    if (writeCommitLog) {
                        CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.cfId, (ReplayPosition)this.val$ctx.get());
                    }
                }
            });
            return future;
        }
        finally {
            Keyspace.switchLock.writeLock().unlock();
        }
    }

    private boolean isClean() {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            if (cfs.getMemtableThreadSafe().isClean()) continue;
            return false;
        }
        return true;
    }

    public Future<?> forceFlush() {
        if (this.isClean()) {
            return postFlushExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    logger.debug("forceFlush requested but everything is clean in {}", (Object)ColumnFamilyStore.this.name);
                }
            });
        }
        return this.switchMemtable(true, false);
    }

    public void forceBlockingFlush() {
        FBUtilities.waitOnFuture(this.forceFlush());
    }

    public void maybeUpdateRowCache(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return;
        }
        RowCacheKey cacheKey = new RowCacheKey(this.metadata.cfId, key);
        this.invalidateCachedRow(cacheKey);
    }

    public void apply(DecoratedKey key, ColumnFamily columnFamily, SecondaryIndexManager.Updater indexer) {
        long start = System.nanoTime();
        Memtable mt = this.getMemtableThreadSafe();
        mt.put(key, columnFamily, indexer);
        this.maybeUpdateRowCache(key);
        this.metric.writeLatency.addNano(System.nanoTime() - start);
        mt.maybeUpdateLiveRatio();
    }

    public static ColumnFamily removeDeletedCF(ColumnFamily cf, int gcBefore) {
        cf.purgeTombstones(gcBefore);
        return cf.getColumnCount() == 0 && !cf.isMarkedForDelete() ? null : cf;
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        return ColumnFamilyStore.removeDeleted(cf, gcBefore, SecondaryIndexManager.nullUpdater);
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        if (cf == null) {
            return null;
        }
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore, indexer);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    public static long removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore, SecondaryIndexManager.Updater indexer) {
        Iterator<Column> iter = cf.iterator();
        DeletionInfo.InOrderTester tester = cf.inOrderDeletionTester();
        boolean hasDroppedColumns = !cf.metadata.getDroppedColumns().isEmpty();
        long removedBytes = 0L;
        while (iter.hasNext()) {
            Column c = iter.next();
            if (c.getLocalDeletionTime() >= gcBefore && !tester.isDeleted(c) && (!hasDroppedColumns || !ColumnFamilyStore.isDroppedColumn(c, cf.metadata()))) continue;
            iter.remove();
            indexer.remove(c);
            removedBytes += (long)c.dataSize();
        }
        return removedBytes;
    }

    public static long removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore) {
        return ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore, SecondaryIndexManager.nullUpdater);
    }

    private static boolean isDroppedColumn(Column c, CFMetaData meta) {
        Long droppedAt = meta.getDroppedColumns().get(((CompositeType)meta.comparator).extractLastComponent(c.name()));
        return droppedAt != null && c.timestamp() <= droppedAt;
    }

    private void removeDroppedColumns(ColumnFamily cf) {
        if (cf == null || cf.metadata.getDroppedColumns().isEmpty()) {
            return;
        }
        Iterator<Column> iter = cf.iterator();
        while (iter.hasNext()) {
            if (!ColumnFamilyStore.isDroppedColumn(iter.next(), this.metadata)) continue;
            iter.remove();
        }
    }

    public Set<SSTableReader> getOverlappingSSTables(Collection<SSTableReader> sstables) {
        logger.debug("Checking for sstables overlapping {}", sstables);
        if (sstables.isEmpty()) {
            return ImmutableSet.of();
        }
        DataTracker.SSTableIntervalTree tree = this.data.getView().intervalTree;
        Sets.SetView results = null;
        for (SSTableReader sstable : sstables) {
            ImmutableSet overlaps = ImmutableSet.copyOf(tree.search(Interval.create(sstable.first, sstable.last)));
            results = results == null ? overlaps : Sets.union((Set)results, (Set)overlaps).immutableCopy();
        }
        results = Sets.difference(results, (Set)ImmutableSet.copyOf(sstables));
        return results;
    }

    public Set<SSTableReader> getAndReferenceOverlappingSSTables(Collection<SSTableReader> sstables) {
        Set<SSTableReader> overlapped;
        while (!SSTableReader.acquireReferences(overlapped = this.getOverlappingSSTables(sstables))) {
        }
        return overlapped;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.name));
        this.addSSTables(Arrays.asList(sstable));
    }

    public void addSSTables(Collection<SSTableReader> sstables) {
        this.data.addSSTables(sstables);
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables, OperationType operation) {
        if (operation != OperationType.CLEANUP || this.isIndex()) {
            return SSTable.getTotalBytes(sstables);
        }
        long expectedFileSize = 0L;
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.keyspace.getName());
        for (SSTableReader sstable : sstables) {
            List<Pair<Long, Long>> positions = sstable.getPositionsForRanges(ranges);
            for (Pair<Long, Long> position : positions) {
                expectedFileSize += (Long)position.right - (Long)position.left;
            }
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public void forceCleanup(CounterId.OneShotRenewer renewer) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performCleanup(this, renewer);
    }

    public void scrub(boolean disableSnapshot, boolean skipCorrupted) throws ExecutionException, InterruptedException {
        if (!disableSnapshot) {
            this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        }
        CompactionManager.instance.performScrub(this, skipCorrupted);
    }

    public void sstablesRewrite(boolean excludeCurrentVersion) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performSSTableRewrite(this, excludeCurrentVersion);
    }

    public void markObsolete(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        this.data.markObsolete(sstables, compactionType);
    }

    public void replaceCompactedSSTables(Collection<SSTableReader> sstables, Collection<SSTableReader> replacements, OperationType compactionType) {
        this.data.replaceCompactedSSTables(sstables, replacements, compactionType);
    }

    void replaceFlushed(Memtable memtable, SSTableReader sstable) {
        this.compactionStrategy.replaceFlushed(memtable, sstable);
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long getMemtableColumnsCount() {
        return (Long)this.metric.memtableColumnsCount.value();
    }

    @Override
    public long getMemtableDataSize() {
        return (Long)this.metric.memtableDataSize.value();
    }

    public long getTotalMemtableLiveSize() {
        return this.getMemtableDataSize() + this.indexManager.getTotalLiveSize();
    }

    public long getAllMemtablesLiveSize() {
        long size = 0L;
        for (Memtable mt : this.getDataTracker().getAllMemtables()) {
            size += mt.getLiveSize();
        }
        return size;
    }

    public long getTotalAllMemtablesLiveSize() {
        long size = this.getAllMemtablesLiveSize();
        if (this.indexManager.hasIndexes()) {
            for (ColumnFamilyStore index : this.indexManager.getIndexesBackedByCfs()) {
                size += index.getAllMemtablesLiveSize();
            }
        }
        return size;
    }

    @Override
    public int getMemtableSwitchCount() {
        return (int)this.metric.memtableSwitchCount.count();
    }

    Memtable getMemtableThreadSafe() {
        return this.data.getMemtable();
    }

    public DataTracker getDataTracker() {
        return this.data;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.data.getSSTables();
    }

    public Set<SSTableReader> getUncompactingSSTables() {
        return this.data.getUncompactingSSTables();
    }

    @Override
    public long[] getRecentSSTablesPerReadHistogram() {
        return this.metric.recentSSTablesPerRead.getBuckets(true);
    }

    @Override
    public long[] getSSTablesPerReadHistogram() {
        return this.metric.sstablesPerRead.getBuckets(false);
    }

    @Override
    public long getReadCount() {
        return this.metric.readLatency.latency.count();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return this.metric.readLatency.getRecentLatency();
    }

    @Override
    public long[] getLifetimeReadLatencyHistogramMicros() {
        return this.metric.readLatency.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return this.metric.readLatency.recentLatencyHistogram.getBuckets(true);
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return this.metric.readLatency.totalLatency.count();
    }

    @Override
    public int getPendingTasks() {
        return (Integer)this.metric.pendingTasks.value();
    }

    @Override
    public long getWriteCount() {
        return this.metric.writeLatency.latency.count();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return this.metric.writeLatency.totalLatency.count();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return this.metric.writeLatency.getRecentLatency();
    }

    @Override
    public long[] getLifetimeWriteLatencyHistogramMicros() {
        return this.metric.writeLatency.totalLatencyHistogram.getBuckets(false);
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return this.metric.writeLatency.recentLatencyHistogram.getBuckets(true);
    }

    public ColumnFamily getColumnFamily(DecoratedKey key, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit, long timestamp) {
        return this.getColumnFamily(QueryFilter.getSliceFilter(key, this.name, start, finish, reversed, limit, timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getThroughCache(UUID cfId, QueryFilter filter) {
        assert (this.isRowCacheEnabled()) : String.format("Row cache is not enabled on column family [" + this.name + "]", new Object[0]);
        RowCacheKey key = new RowCacheKey(cfId, filter.key);
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                return this.getTopLevelColumns(filter, Integer.MIN_VALUE);
            }
            Tracing.trace("Row cache hit");
            return (ColumnFamily)cached;
        }
        Tracing.trace("Row cache miss");
        RowCacheSentinel sentinel = new RowCacheSentinel();
        boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
        try {
            ColumnFamily data = this.getTopLevelColumns(QueryFilter.getIdentityFilter(filter.key, this.name, filter.timestamp), Integer.MIN_VALUE);
            if (sentinelSuccess && data != null) {
                CacheService.instance.rowCache.replace(key, sentinel, data);
            }
            ColumnFamily columnFamily = data;
            return columnFamily;
        }
        finally {
            if (sentinelSuccess && this.data == null) {
                this.invalidateCachedRow(key);
            }
        }
    }

    public int gcBefore(long now) {
        return (int)(now / 1000L) - this.metadata.getGcGraceSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnFamily getColumnFamily(QueryFilter filter) {
        assert (this.name.equals(filter.getColumnFamilyName())) : filter.getColumnFamilyName();
        ColumnFamily result = null;
        long start = System.nanoTime();
        try {
            int gcBefore = this.gcBefore(filter.timestamp);
            if (this.isRowCacheEnabled()) {
                assert (!this.isIndex());
                UUID cfId = this.metadata.cfId;
                ColumnFamily cached = this.getThroughCache(cfId, filter);
                if (cached == null) {
                    logger.trace("cached row is empty");
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                result = this.filterColumnFamily(cached, filter);
            } else {
                ColumnFamily cf = this.getTopLevelColumns(filter, gcBefore);
                if (cf == null) {
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                result = ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
            }
            this.removeDroppedColumns(result);
            if (filter.filter instanceof SliceQueryFilter) {
                this.metric.tombstoneScannedHistogram.update(((SliceQueryFilter)filter.filter).lastIgnored());
                this.metric.liveScannedHistogram.update(((SliceQueryFilter)filter.filter).lastLive());
            }
        }
        finally {
            this.metric.readLatency.addNano(System.nanoTime() - start);
        }
        return result;
    }

    ColumnFamily filterColumnFamily(ColumnFamily cached, QueryFilter filter) {
        ArrayBackedSortedColumns cf = cached.cloneMeShallow(ArrayBackedSortedColumns.factory, filter.filter.isReversed());
        OnDiskAtomIterator ci = filter.getColumnFamilyIterator(cached);
        int gcBefore = this.gcBefore(filter.timestamp);
        filter.collateOnDiskAtom((ColumnFamily)cf, ci, gcBefore);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    private DataTracker.View markCurrentViewReferenced() {
        DataTracker.View currentView;
        do {
            currentView = this.data.getView();
        } while (!SSTableReader.acquireReferences(currentView.sstables));
        return currentView;
    }

    public Collection<SSTableReader> markCurrentSSTablesReferenced() {
        return this.markCurrentViewReferenced().sstables;
    }

    private ViewFragment markReferenced(Function<DataTracker.View, List<SSTableReader>> filter) {
        DataTracker.View view;
        List sstables;
        do {
            view = this.data.getView();
            if (!view.intervalTree.isEmpty()) continue;
            sstables = Collections.emptyList();
            break;
        } while (!SSTableReader.acquireReferences(sstables = (List)filter.apply((Object)view)));
        return new ViewFragment(sstables, Iterables.concat(Collections.singleton(view.memtable), view.memtablesPendingFlush));
    }

    public ViewFragment markReferenced(final DecoratedKey key) {
        assert (!key.isMinimum(this.partitioner));
        return this.markReferenced(new Function<DataTracker.View, List<SSTableReader>>(){

            public List<SSTableReader> apply(DataTracker.View view) {
                return ColumnFamilyStore.this.compactionStrategy.filterSSTablesForReads(view.intervalTree.search(key));
            }
        });
    }

    public ViewFragment markReferenced(final AbstractBounds<RowPosition> rowBounds) {
        return this.markReferenced(new Function<DataTracker.View, List<SSTableReader>>(){

            public List<SSTableReader> apply(DataTracker.View view) {
                return ColumnFamilyStore.this.compactionStrategy.filterSSTablesForReads(view.sstablesInBounds(rowBounds));
            }
        });
    }

    public ViewFragment markReferenced(final Collection<AbstractBounds<RowPosition>> rowBoundsCollection) {
        return this.markReferenced(new Function<DataTracker.View, List<SSTableReader>>(){

            public List<SSTableReader> apply(DataTracker.View view) {
                HashSet sstables = Sets.newHashSet();
                for (AbstractBounds rowBounds : rowBoundsCollection) {
                    sstables.addAll(view.sstablesInBounds(rowBounds));
                }
                return ImmutableList.copyOf((Collection)sstables);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSSTablesForKey(String key) {
        DecoratedKey dk = this.partitioner.decorateKey(this.metadata.getKeyValidator().fromString(key));
        ViewFragment view = this.markReferenced(dk);
        try {
            ArrayList<String> files = new ArrayList<String>();
            for (SSTableReader sstr : view.sstables) {
                if (sstr.getPosition(dk, SSTableReader.Operator.EQ, false) == null) continue;
                files.add(sstr.getFilename());
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
        finally {
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    public ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore) {
        Tracing.trace("Executing single-partition query on {}", this.name);
        CollationController controller = new CollationController(this, filter, gcBefore);
        ColumnFamily columns = controller.getTopLevelColumns();
        this.metric.updateSSTableIterated(controller.getSstablesIterated());
        return columns;
    }

    public void cleanupCache() {
        Collection ranges = StorageService.instance.getLocalRanges(this.keyspace.getName());
        for (RowCacheKey key : CacheService.instance.rowCache.getKeySet()) {
            DecoratedKey dk = this.partitioner.decorateKey(ByteBuffer.wrap(key.key));
            if (key.cfId != this.metadata.cfId || Range.isInRanges(dk.token, ranges)) continue;
            this.invalidateCachedRow(dk);
        }
    }

    private AbstractScanIterator getSequentialIterator(final DataRange range, long now) {
        assert (!(range.keyRange() instanceof Range) || !((Range)range.keyRange()).isWrapAround() || ((RowPosition)range.keyRange().right).isMinimum(this.partitioner)) : range.keyRange();
        final ViewFragment view = this.markReferenced(range.keyRange());
        Tracing.trace("Executing seq scan across {} sstables for {}", view.sstables.size(), range.keyRange().getString(this.metadata.getKeyValidator()));
        try {
            final CloseableIterator<Row> iterator = RowIteratorFactory.getIterator(view.memtables, view.sstables, range, this, now);
            return new AbstractScanIterator(){

                protected Row computeNext() {
                    if (!iterator.hasNext()) {
                        return (Row)this.endOfData();
                    }
                    Row current = (Row)iterator.next();
                    DecoratedKey key = current.key;
                    if (!range.stopKey().isMinimum(ColumnFamilyStore.this.partitioner) && range.stopKey().compareTo(key) < 0) {
                        return (Row)this.endOfData();
                    }
                    if (!range.contains(key)) {
                        return this.computeNext();
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("scanned {}", (Object)ColumnFamilyStore.this.metadata.getKeyValidator().getString(key.key));
                    }
                    return current;
                }

                @Override
                public void close() throws IOException {
                    SSTableReader.releaseReferences(view.sstables);
                    iterator.close();
                }
            };
        }
        catch (RuntimeException e) {
            SSTableReader.releaseReferences(view.sstables);
            throw e;
        }
    }

    @VisibleForTesting
    public List<Row> getRangeSlice(AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, IDiskAtomFilter columnFilter, int maxResults) {
        return this.getRangeSlice(range, rowFilter, columnFilter, maxResults, System.currentTimeMillis());
    }

    public List<Row> getRangeSlice(AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, IDiskAtomFilter columnFilter, int maxResults, long now) {
        return this.getRangeSlice(this.makeExtendedFilter(range, columnFilter, rowFilter, maxResults, false, false, now));
    }

    public ExtendedFilter makeExtendedFilter(AbstractBounds<RowPosition> keyRange, SliceQueryFilter columnRange, ByteBuffer columnStart, ByteBuffer columnStop, List<IndexExpression> rowFilter, int maxResults, boolean countCQL3Rows, long now) {
        DataRange.Paging dataRange = new DataRange.Paging(keyRange, columnRange, columnStart, columnStop, this.metadata.comparator);
        return ExtendedFilter.create(this, dataRange, rowFilter, maxResults, countCQL3Rows, now);
    }

    public List<Row> getRangeSlice(AbstractBounds<RowPosition> range, List<IndexExpression> rowFilter, IDiskAtomFilter columnFilter, int maxResults, long now, boolean countCQL3Rows, boolean isPaging) {
        return this.getRangeSlice(this.makeExtendedFilter(range, columnFilter, rowFilter, maxResults, countCQL3Rows, isPaging, now));
    }

    public ExtendedFilter makeExtendedFilter(AbstractBounds<RowPosition> range, IDiskAtomFilter columnFilter, List<IndexExpression> rowFilter, int maxResults, boolean countCQL3Rows, boolean isPaging, long timestamp) {
        DataRange dataRange;
        if (isPaging) {
            assert (columnFilter instanceof SliceQueryFilter);
            SliceQueryFilter sfilter = (SliceQueryFilter)columnFilter;
            assert (sfilter.slices.length == 1);
            SliceQueryFilter newFilter = new SliceQueryFilter(ColumnSlice.ALL_COLUMNS_ARRAY, sfilter.isReversed(), sfilter.count);
            dataRange = new DataRange.Paging(range, newFilter, sfilter.start(), sfilter.finish(), this.metadata.comparator);
        } else {
            dataRange = new DataRange(range, columnFilter);
        }
        return ExtendedFilter.create(this, dataRange, rowFilter, maxResults, countCQL3Rows, timestamp);
    }

    public List<Row> getRangeSlice(ExtendedFilter filter) {
        return this.filter(this.getSequentialIterator(filter.dataRange, filter.timestamp), filter);
    }

    @VisibleForTesting
    public List<Row> search(AbstractBounds<RowPosition> range, List<IndexExpression> clause, IDiskAtomFilter dataFilter, int maxResults) {
        return this.search(range, clause, dataFilter, maxResults, System.currentTimeMillis());
    }

    public List<Row> search(AbstractBounds<RowPosition> range, List<IndexExpression> clause, IDiskAtomFilter dataFilter, int maxResults, long now) {
        return this.search(this.makeExtendedFilter(range, dataFilter, clause, maxResults, false, false, now));
    }

    public List<Row> search(ExtendedFilter filter) {
        Tracing.trace("Executing indexed scan for {}", filter.dataRange.keyRange().getString(this.metadata.getKeyValidator()));
        return this.indexManager.search(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> filter(AbstractScanIterator rowIterator, ExtendedFilter filter) {
        logger.trace("Filtering {} for rows matching {}", (Object)rowIterator, (Object)filter);
        ArrayList<Row> rows = new ArrayList<Row>();
        int columnsCount = 0;
        int total = 0;
        int matched = 0;
        try {
            while (rowIterator.hasNext() && matched < filter.maxRows() && columnsCount < filter.maxColumns()) {
                Row rawRow = (Row)rowIterator.next();
                ++total;
                ColumnFamily data = rawRow.cf;
                if (rowIterator.needsFiltering()) {
                    ColumnFamily cf;
                    IDiskAtomFilter extraFilter = filter.getExtraFilter(rawRow.key, data);
                    if (extraFilter != null && (cf = filter.cfs.getColumnFamily(new QueryFilter(rawRow.key, this.name, extraFilter, filter.timestamp))) != null) {
                        data.addAll(cf, HeapAllocator.instance);
                    }
                    this.removeDroppedColumns(data);
                    if (!filter.isSatisfiedBy(rawRow.key, data, null)) continue;
                    logger.trace("{} satisfies all filter expressions", (Object)data);
                    data = filter.prune(rawRow.key, data);
                } else {
                    this.removeDroppedColumns(data);
                }
                rows.add(new Row(rawRow.key, data));
                ++matched;
                if (data != null) {
                    columnsCount += filter.lastCounted(data);
                }
                filter.updateFilter(columnsCount);
            }
            ArrayList<Row> arrayList = rows;
            return arrayList;
        }
        finally {
            try {
                rowIterator.close();
                Tracing.trace("Scanned {} rows and matched {}", total, matched);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public AbstractType<?> getComparator() {
        return this.metadata.comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshotWithoutFlush(String snapshotName) {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            DataTracker.View currentView = cfs.markCurrentViewReferenced();
            try {
                for (SSTableReader ssTable : currentView.sstables) {
                    File snapshotDirectory = Directories.getSnapshotDirectory(ssTable.descriptor, snapshotName);
                    ssTable.createLinks(snapshotDirectory.getPath());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Snapshot for " + this.keyspace + " keyspace data file " + ssTable.getFilename() + " created in " + snapshotDirectory);
                }
                if (!(cfs.compactionStrategy instanceof LeveledCompactionStrategy)) continue;
                cfs.directories.snapshotLeveledManifest(snapshotName);
            }
            finally {
                SSTableReader.releaseReferences(currentView.sstables);
            }
        }
    }

    public List<SSTableReader> getSnapshotSSTableReader(String tag) throws IOException {
        Map<Descriptor, Set<Component>> snapshots = this.directories.sstableLister().snapshots(tag).list();
        ArrayList<SSTableReader> readers = new ArrayList<SSTableReader>(snapshots.size());
        for (Map.Entry<Descriptor, Set<Component>> entries : snapshots.entrySet()) {
            readers.add(SSTableReader.open(entries.getKey(), entries.getValue(), this.metadata, this.partitioner));
        }
        return readers;
    }

    public void snapshot(String snapshotName) {
        this.forceBlockingFlush();
        this.snapshotWithoutFlush(snapshotName);
    }

    public boolean snapshotExists(String snapshotName) {
        return this.directories.snapshotExists(snapshotName);
    }

    public long getSnapshotCreationTime(String snapshotName) {
        return this.directories.snapshotCreationTime(snapshotName);
    }

    public void clearSnapshot(String snapshotName) {
        List<File> snapshotDirs = this.directories.getCFDirectories();
        Directories.clearSnapshot(snapshotName, snapshotDirs);
    }

    public boolean hasUnreclaimedSpace() {
        return this.getLiveDiskSpaceUsed() < this.getTotalDiskSpaceUsed();
    }

    @Override
    public long getTotalDiskSpaceUsed() {
        return this.metric.totalDiskSpaceUsed.count();
    }

    @Override
    public long getLiveDiskSpaceUsed() {
        return this.metric.liveDiskSpaceUsed.count();
    }

    @Override
    public int getLiveSSTableCount() {
        return (Integer)this.metric.liveSSTableCount.value();
    }

    public ColumnFamily getRawCachedRow(DecoratedKey key) {
        if (!this.isRowCacheEnabled()) {
            return null;
        }
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.getInternal(new RowCacheKey(this.metadata.cfId, key));
        return cached == null || cached instanceof RowCacheSentinel ? null : (ColumnFamily)cached;
    }

    public boolean containsCachedRow(DecoratedKey key) {
        return CacheService.instance.rowCache.getCapacity() != 0L && CacheService.instance.rowCache.containsKey(new RowCacheKey(this.metadata.cfId, key));
    }

    public void invalidateCachedRow(RowCacheKey key) {
        CacheService.instance.rowCache.remove(key);
    }

    public void invalidateCachedRow(DecoratedKey key) {
        UUID cfId = Schema.instance.getId(this.keyspace.getName(), this.name);
        if (cfId == null) {
            return;
        }
        this.invalidateCachedRow(new RowCacheKey(cfId, key));
    }

    @Override
    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMaximal(this);
    }

    public static Iterable<ColumnFamilyStore> all() {
        ArrayList<Collection<ColumnFamilyStore>> stores = new ArrayList<Collection<ColumnFamilyStore>>(Schema.instance.getKeyspaces().size());
        for (Keyspace keyspace : Keyspace.all()) {
            stores.add(keyspace.getColumnFamilyStores());
        }
        return Iterables.concat(stores);
    }

    public Iterable<DecoratedKey> keySamples(Range<Token> range) {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples(range);
        }
        return Iterables.concat((Iterable[])samples);
    }

    public void clearUnsafe() {
        for (final ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.runWithCompactionsDisabled(new Callable<Void>(){

                @Override
                public Void call() {
                    cfs.data.init();
                    return null;
                }
            }, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateBlocking() {
        logger.debug("truncating {}", (Object)this.name);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.forceBlockingFlush();
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        Keyspace.switchLock.writeLock().lock();
        try {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                Memtable mt = cfs.getMemtableThreadSafe();
                if (mt.isClean()) continue;
                mt.cfs.data.renewMemtable();
            }
        }
        finally {
            Keyspace.switchLock.writeLock().unlock();
        }
        Runnable truncateRunnable = new Runnable(){

            @Override
            public void run() {
                logger.debug("Discarding sstable data for truncated CF + indexes");
                long truncatedAt = System.currentTimeMillis();
                if (DatabaseDescriptor.isAutoSnapshot()) {
                    ColumnFamilyStore.this.snapshot(Keyspace.getTimestampedSnapshotName(ColumnFamilyStore.this.name));
                }
                ReplayPosition replayAfter = ColumnFamilyStore.this.discardSSTables(truncatedAt);
                for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexes()) {
                    index.truncateBlocking(truncatedAt);
                }
                SystemKeyspace.saveTruncationRecord(ColumnFamilyStore.this, truncatedAt, replayAfter);
                logger.debug("cleaning out row cache");
                for (RowCacheKey key : CacheService.instance.rowCache.getKeySet()) {
                    if (key.cfId != ColumnFamilyStore.this.metadata.cfId) continue;
                    ColumnFamilyStore.this.invalidateCachedRow(key);
                }
            }
        };
        this.runWithCompactionsDisabled(Executors.callable(truncateRunnable), true);
        logger.debug("truncate complete");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public <V> V runWithCompactionsDisabled(Callable<V> callable, boolean interruptValidation) {
        ColumnFamilyStore columnFamilyStore = this;
        synchronized (columnFamilyStore) {
            logger.debug("Cancelling in-progress compactions for {}", (Object)this.metadata.cfName);
            Iterable<ColumnFamilyStore> selfWithIndexes = this.concatWithIndexes();
            for (ColumnFamilyStore cfs : selfWithIndexes) {
                cfs.getCompactionStrategy().pause();
            }
            Function<ColumnFamilyStore, CFMetaData> f = new Function<ColumnFamilyStore, CFMetaData>(){

                public CFMetaData apply(ColumnFamilyStore cfs) {
                    return cfs.metadata;
                }
            };
            Iterable allMetadata = Iterables.transform(selfWithIndexes, (Function)f);
            CompactionManager.instance.interruptCompactionFor(allMetadata, interruptValidation);
            long start = System.nanoTime();
            long delay = TimeUnit.MINUTES.toNanos(1L);
            while (System.nanoTime() - start < delay && CompactionManager.instance.isCompacting(selfWithIndexes)) {
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            for (ColumnFamilyStore cfs : selfWithIndexes) {
                if (cfs.getDataTracker().getCompacting().isEmpty()) continue;
                logger.warn("Unable to cancel in-progress compactions for {}.  Probably there is an unusually large row in progress somewhere.  It is also possible that buggy code left some sstables compacting after it was done with them", (Object)this.metadata.cfName);
            }
            logger.debug("Compactions successfully cancelled");
            Iterator<ColumnFamilyStore> i$ = callable.call();
            return (V)i$;
            {
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                for (ColumnFamilyStore cfs : selfWithIndexes) {
                    cfs.getCompactionStrategy().resume();
                }
            }
        }
    }

    public Iterable<SSTableReader> markAllCompacting() {
        Callable<Iterable<SSTableReader>> callable = new Callable<Iterable<SSTableReader>>(){

            @Override
            public Iterable<SSTableReader> call() throws Exception {
                assert (ColumnFamilyStore.this.data.getCompacting().isEmpty()) : ColumnFamilyStore.access$300(ColumnFamilyStore.this).getCompacting();
                ArrayList sstables = Lists.newArrayList(AbstractCompactionStrategy.filterSuspectSSTables(ColumnFamilyStore.this.getSSTables()));
                if (Iterables.isEmpty((Iterable)sstables)) {
                    return null;
                }
                boolean success = ColumnFamilyStore.this.data.markCompacting(sstables);
                assert (success) : "something marked things compacting while compactions are disabled";
                return sstables;
            }
        };
        return this.runWithCompactionsDisabled(callable, false);
    }

    @Override
    public long getBloomFilterFalsePositives() {
        return (Long)this.metric.bloomFilterFalsePositives.value();
    }

    @Override
    public long getRecentBloomFilterFalsePositives() {
        return (Long)this.metric.recentBloomFilterFalsePositives.value();
    }

    @Override
    public double getBloomFilterFalseRatio() {
        return (Double)this.metric.bloomFilterFalseRatio.value();
    }

    @Override
    public double getRecentBloomFilterFalseRatio() {
        return (Double)this.metric.recentBloomFilterFalseRatio.value();
    }

    @Override
    public long getBloomFilterDiskSpaceUsed() {
        return (Long)this.metric.bloomFilterDiskSpaceUsed.value();
    }

    public String toString() {
        return "CFS(Keyspace='" + this.keyspace.getName() + '\'' + ", ColumnFamily='" + this.name + '\'' + ')';
    }

    public void disableAutoCompaction() {
        this.compactionStrategy.disable();
    }

    public void enableAutoCompaction() {
        this.enableAutoCompaction(false);
    }

    @VisibleForTesting
    public void enableAutoCompaction(boolean waitForFutures) {
        this.compactionStrategy.enable();
        List<Future<?>> futures = CompactionManager.instance.submitBackground(this);
        if (waitForFutures) {
            FBUtilities.waitOnFutures(futures);
        }
    }

    @Override
    public boolean isAutoCompactionDisabled() {
        return !this.compactionStrategy.isEnabled();
    }

    public AbstractCompactionStrategy getCompactionStrategy() {
        assert (this.compactionStrategy != null) : "No compaction strategy set yet";
        return this.compactionStrategy;
    }

    @Override
    public void setCompactionThresholds(int minThreshold, int maxThreshold) {
        this.validateCompactionThresholds(minThreshold, maxThreshold);
        this.minCompactionThreshold.set(minThreshold);
        this.maxCompactionThreshold.set(maxThreshold);
        if (this.compactionStrategy != null) {
            CompactionManager.instance.submitBackground(this);
        }
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        this.validateCompactionThresholds(minCompactionThreshold, this.maxCompactionThreshold.value());
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        this.validateCompactionThresholds(this.minCompactionThreshold.value(), maxCompactionThreshold);
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    private void validateCompactionThresholds(int minThreshold, int maxThreshold) {
        if (minThreshold > maxThreshold) {
            throw new RuntimeException(String.format("The min_compaction_threshold cannot be larger than the max_compaction_threshold. Min is '%d', Max is '%d'.", minThreshold, maxThreshold));
        }
        if (maxThreshold == 0 || minThreshold == 0) {
            throw new RuntimeException("Disabling compaction by setting min_compaction_threshold or max_compaction_threshold to 0 is deprecated, set the compaction strategy option 'enabled' to 'false' instead or use the nodetool command 'disableautocompaction'.");
        }
    }

    @Override
    public double getTombstonesPerSlice() {
        return this.metric.tombstoneScannedHistogram.getSnapshot().getMedian();
    }

    @Override
    public double getLiveCellsPerSlice() {
        return this.metric.liveScannedHistogram.getSnapshot().getMedian();
    }

    @Override
    public long estimateKeys() {
        return this.data.estimatedKeys();
    }

    @Override
    public long[] getEstimatedRowSizeHistogram() {
        return (long[])this.metric.estimatedRowSizeHistogram.value();
    }

    @Override
    public long[] getEstimatedColumnCountHistogram() {
        return (long[])this.metric.estimatedColumnCountHistogram.value();
    }

    @Override
    public double getCompressionRatio() {
        return (Double)this.metric.compressionRatio.value();
    }

    public boolean isIndex() {
        return this.partitioner instanceof LocalPartitioner;
    }

    private ByteBuffer intern(ByteBuffer name) {
        ByteBuffer concurrentName;
        ByteBuffer internedName = (ByteBuffer)this.internedNames.get(name);
        if (internedName == null && (concurrentName = this.internedNames.putIfAbsent(internedName = ByteBufferUtil.clone(name), internedName)) != null) {
            internedName = concurrentName;
        }
        return internedName;
    }

    public ByteBuffer internOrCopy(ByteBuffer name, Allocator allocator) {
        if (this.internedNames.size() >= 256) {
            return allocator.clone(name);
        }
        return this.intern(name);
    }

    public ByteBuffer maybeIntern(ByteBuffer name) {
        if (this.internedNames.size() >= 256) {
            return null;
        }
        return this.intern(name);
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(this.indexManager.getIndexesBackedByCfs(), Collections.singleton(this));
    }

    public Set<Memtable> getMemtablesPendingFlush() {
        return this.data.getMemtablesPendingFlush();
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexes();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategy instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.compactionStrategy).getLevelSize(0) : 0;
    }

    @Override
    public int[] getSSTableCountPerLevel() {
        return this.compactionStrategy instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.compactionStrategy).getAllLevelSize() : null;
    }

    public long oldestUnflushedMemtable() {
        DataTracker.View view = this.data.getView();
        long oldest = view.memtable.creationTime();
        for (Memtable memtable : view.memtablesPendingFlush) {
            oldest = Math.min(oldest, memtable.creationTime());
        }
        return oldest;
    }

    public boolean isEmpty() {
        DataTracker.View view = this.data.getView();
        return view.sstables.isEmpty() && view.memtable.getOperations() == 0L && view.memtablesPendingFlush.isEmpty();
    }

    private boolean isRowCacheEnabled() {
        return this.metadata.getCaching() != CFMetaData.Caching.NONE && this.metadata.getCaching() != CFMetaData.Caching.KEYS_ONLY && CacheService.instance.rowCache.getCapacity() != 0L;
    }

    public ReplayPosition discardSSTables(long truncatedAt) {
        assert (this.data.getCompacting().isEmpty()) : this.data.getCompacting();
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : this.getSSTables()) {
            if (sstable.newSince(truncatedAt)) continue;
            truncatedSSTables.add(sstable);
        }
        if (truncatedSSTables.isEmpty()) {
            return ReplayPosition.NONE;
        }
        this.markObsolete(truncatedSSTables, OperationType.UNKNOWN);
        return ReplayPosition.getReplayPosition(truncatedSSTables);
    }

    @Override
    public double getDroppableTombstoneRatio() {
        return this.getDataTracker().getDroppableTombstoneRatio();
    }

    @VisibleForTesting
    void resetFileIndexGenerator() {
        this.fileIndexGenerator.set(0);
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    public static abstract class AbstractScanIterator
    extends AbstractIterator<Row>
    implements CloseableIterator<Row> {
        public boolean needsFiltering() {
            return true;
        }
    }
}

