/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.StreamMessage;
import org.apache.cassandra.utils.UUIDSerializer;

public class RetryMessage
extends StreamMessage {
    public static StreamMessage.Serializer<RetryMessage> serializer = new StreamMessage.Serializer<RetryMessage>(){

        @Override
        public RetryMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
            DataInputStream input = new DataInputStream(Channels.newInputStream(in));
            return new RetryMessage(UUIDSerializer.serializer.deserialize(input, 7), input.readInt());
        }

        @Override
        public void serialize(RetryMessage message, WritableByteChannel out, int version, StreamSession session) throws IOException {
            DataOutputStream output = new DataOutputStream(Channels.newOutputStream(out));
            UUIDSerializer.serializer.serialize(message.cfId, (DataOutput)output, 7);
            output.writeInt(message.sequenceNumber);
        }
    };
    public final UUID cfId;
    public final int sequenceNumber;

    public RetryMessage(UUID cfId, int sequenceNumber) {
        super(StreamMessage.Type.RETRY);
        this.cfId = cfId;
        this.sequenceNumber = sequenceNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Retry (");
        sb.append(this.cfId).append(", #").append(this.sequenceNumber).append(')');
        return sb.toString();
    }
}

