/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.routing.ShardIterator;

public class GroupShardsIterator
implements Iterable<ShardIterator> {
    private final List<ShardIterator> iterators;

    public GroupShardsIterator(List<ShardIterator> iterators) {
        CollectionUtil.timSort(iterators);
        this.iterators = iterators;
    }

    public int totalSize() {
        int size = 0;
        for (ShardIterator shard : this.iterators) {
            size += shard.size();
        }
        return size;
    }

    public int totalSizeWith1ForEmpty() {
        int size = 0;
        for (ShardIterator shard : this.iterators) {
            int sizeActive = shard.size();
            if (sizeActive == 0) {
                ++size;
                continue;
            }
            size += sizeActive;
        }
        return size;
    }

    public int size() {
        return this.iterators.size();
    }

    @Override
    public Iterator<ShardIterator> iterator() {
        return this.iterators.iterator();
    }
}

