/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.lzf.LZFCompressor;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.settings.Settings;

public class CompressorFactory {
    private static final LZFCompressor LZF = new LZFCompressor();
    private static final Compressor[] compressors;
    private static final ImmutableMap<String, Compressor> compressorsByType;
    private static Compressor defaultCompressor;

    public static synchronized void configure(Settings settings) {
        for (Compressor compressor : compressors) {
            compressor.configure(settings);
        }
        String defaultType = settings.get("compress.default.type", "lzf").toLowerCase(Locale.ENGLISH);
        boolean found = false;
        for (Compressor compressor : compressors) {
            if (!defaultType.equalsIgnoreCase(compressor.type())) continue;
            defaultCompressor = compressor;
            found = true;
            break;
        }
        if (!found) {
            Loggers.getLogger(CompressorFactory.class).warn("failed to find default type [{}]", defaultType);
        }
    }

    public static synchronized void setDefaultCompressor(Compressor defaultCompressor) {
        CompressorFactory.defaultCompressor = defaultCompressor;
    }

    public static Compressor defaultCompressor() {
        return defaultCompressor;
    }

    public static boolean isCompressed(BytesReference bytes) {
        return CompressorFactory.compressor(bytes) != null;
    }

    public static boolean isCompressed(byte[] data) {
        return CompressorFactory.compressor(data, 0, data.length) != null;
    }

    public static boolean isCompressed(byte[] data, int offset, int length) {
        return CompressorFactory.compressor(data, offset, length) != null;
    }

    public static boolean isCompressed(IndexInput in) throws IOException {
        return CompressorFactory.compressor(in) != null;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(bytes)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(byte[] data) {
        return CompressorFactory.compressor(data, 0, data.length);
    }

    @Nullable
    public static Compressor compressor(byte[] data, int offset, int length) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(data, offset, length)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(ChannelBuffer buffer) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(buffer)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(IndexInput in) throws IOException {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(in)) continue;
            return compressor;
        }
        return null;
    }

    public static Compressor compressor(String type) {
        return compressorsByType.get(type);
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes);
        if (compressor != null) {
            if (bytes.hasArray()) {
                return new BytesArray(compressor.uncompress(bytes.array(), bytes.arrayOffset(), bytes.length()));
            }
            CompressedStreamInput compressed = compressor.streamInput(bytes.streamInput());
            BytesStreamOutput bStream = new BytesStreamOutput();
            Streams.copy(compressed, (OutputStream)bStream);
            ((StreamInput)compressed).close();
            return bStream.bytes();
        }
        return bytes;
    }

    static {
        ArrayList<LZFCompressor> compressorsX = Lists.newArrayList();
        compressorsX.add(LZF);
        compressors = compressorsX.toArray(new Compressor[compressorsX.size()]);
        MapBuilder<String, Compressor> compressorsByTypeX = MapBuilder.newMapBuilder();
        for (Compressor compressor : compressors) {
            compressorsByTypeX.put(compressor.type(), compressor);
        }
        compressorsByType = compressorsByTypeX.immutableMap();
        defaultCompressor = LZF;
    }
}

