/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;

public interface ZenPing
extends LifecycleComponent<ZenPing> {
    public void setPingContextProvider(PingContextProvider var1);

    public void ping(PingListener var1, TimeValue var2) throws ElasticsearchException;

    public static class PingCollection {
        Map<DiscoveryNode, PingResponse> pings = new HashMap<DiscoveryNode, PingResponse>();

        public synchronized boolean addPing(PingResponse ping) {
            PingResponse existingResponse = this.pings.get(ping.node());
            if (existingResponse == null || existingResponse.id() <= ping.id()) {
                this.pings.put(ping.node(), ping);
                return true;
            }
            return false;
        }

        public synchronized void addPings(PingResponse[] pings) {
            for (PingResponse ping : pings) {
                this.addPing(ping);
            }
        }

        public synchronized PingResponse[] toArray() {
            return this.pings.values().toArray(new PingResponse[this.pings.size()]);
        }

        public synchronized int size() {
            return this.pings.size();
        }
    }

    public static class PingResponse
    implements Streamable {
        public static final PingResponse[] EMPTY = new PingResponse[0];
        private static final AtomicLong idGenerator = new AtomicLong();
        private static final long UNKNOWN_ID = -1L;
        private long id;
        private ClusterName clusterName;
        private DiscoveryNode node;
        private DiscoveryNode master;
        @Nullable
        private Boolean hasJoinedOnce;

        private PingResponse() {
        }

        public PingResponse(DiscoveryNode node, DiscoveryNode master, ClusterName clusterName, boolean hasJoinedOnce) {
            this.id = idGenerator.incrementAndGet();
            this.node = node;
            this.master = master;
            this.clusterName = clusterName;
            this.hasJoinedOnce = hasJoinedOnce;
        }

        public long id() {
            return this.id;
        }

        public ClusterName clusterName() {
            return this.clusterName;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public DiscoveryNode master() {
            return this.master;
        }

        @Nullable
        public Boolean hasJoinedOnce() {
            return this.hasJoinedOnce;
        }

        public static PingResponse readPingResponse(StreamInput in) throws IOException {
            PingResponse response = new PingResponse();
            response.readFrom(in);
            return response;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.clusterName = ClusterName.readClusterName(in);
            this.node = DiscoveryNode.readNode(in);
            if (in.readBoolean()) {
                this.master = DiscoveryNode.readNode(in);
            }
            if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                if (in.readBoolean()) {
                    this.hasJoinedOnce = in.readBoolean();
                }
                this.id = in.readLong();
            } else {
                this.hasJoinedOnce = null;
                this.id = -1L;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.clusterName.writeTo(out);
            this.node.writeTo(out);
            if (this.master == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.master.writeTo(out);
            }
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                if (this.hasJoinedOnce != null) {
                    out.writeBoolean(true);
                    out.writeBoolean(this.hasJoinedOnce);
                } else {
                    out.writeBoolean(false);
                }
                out.writeLong(this.id);
            }
        }

        public String toString() {
            return "ping_response{node [" + this.node + "], id[" + this.id + "], master [" + this.master + "], hasJoinedOnce [" + this.hasJoinedOnce + "], cluster_name[" + this.clusterName.value() + "]}";
        }
    }

    public static interface PingListener {
        public void onPing(PingResponse[] var1);
    }
}

