/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.internal;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Build;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.bulk.udp.BulkUdpModule;
import org.elasticsearch.bulk.udp.BulkUdpService;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.CacheRecyclerModule;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecyclerModule;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClientModule;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterNameModule;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.CachedStreams;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.util.BigArraysModule;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeEnvironmentModule;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.index.search.shape.ShapeModule;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerModule;
import org.elasticsearch.indices.cache.filter.IndicesFilterCache;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.indices.ttl.IndicesTTLService;
import org.elasticsearch.monitor.MonitorModule;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.node.internal.NodeModule;
import org.elasticsearch.percolator.PercolatorModule;
import org.elasticsearch.percolator.PercolatorService;
import org.elasticsearch.plugins.PluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.river.RiversManager;
import org.elasticsearch.river.RiversModule;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolModule;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.tribe.TribeModule;
import org.elasticsearch.tribe.TribeService;
import org.elasticsearch.watcher.ResourceWatcherModule;
import org.elasticsearch.watcher.ResourceWatcherService;

public final class InternalNode
implements Node {
    private static final String CLIENT_TYPE = "node";
    public static final String HTTP_ENABLED = "http.enabled";
    private final Lifecycle lifecycle = new Lifecycle();
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final PluginsService pluginsService;
    private final Client client;

    public InternalNode() throws ElasticsearchException {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalNode(Settings preparedSettings, boolean loadConfigSettings) throws ElasticsearchException {
        Settings pSettings = ImmutableSettings.settingsBuilder().put(preparedSettings).put("client.type", CLIENT_TYPE).build();
        Tuple<Settings, Environment> tuple = InternalSettingsPreparer.prepareSettings(pSettings, loadConfigSettings);
        tuple = new Tuple<Settings, Environment>(TribeService.processSettings(tuple.v1()), tuple.v2());
        Version version = pSettings.getAsVersion("tests.mock.version", Version.CURRENT);
        ESLogger logger = Loggers.getLogger(Node.class, tuple.v1().get("name"));
        logger.info("version[{}], pid[{}], build[{}/{}]", version, JvmInfo.jvmInfo().pid(), Build.CURRENT.hashShort(), Build.CURRENT.timestamp());
        logger.info("initializing ...", new Object[0]);
        if (logger.isDebugEnabled()) {
            Environment env = tuple.v2();
            logger.debug("using home [{}], config [{}], data [{}], logs [{}], work [{}], plugins [{}]", env.homeFile(), env.configFile(), Arrays.toString(env.dataFiles()), env.logsFile(), env.workFile(), env.pluginsFile());
        }
        this.pluginsService = new PluginsService(tuple.v1(), tuple.v2());
        this.settings = this.pluginsService.updatedSettings();
        this.environment = new Environment(this.settings());
        CompressorFactory.configure(this.settings);
        NodeEnvironment nodeEnvironment = new NodeEnvironment(this.settings, this.environment);
        boolean success = false;
        try {
            ModulesBuilder modules = new ModulesBuilder();
            modules.add((Module)new Version.Module(version));
            modules.add((Module)new CacheRecyclerModule(this.settings));
            modules.add((Module)new PageCacheRecyclerModule(this.settings));
            modules.add((Module)new CircuitBreakerModule(this.settings));
            modules.add((Module)new BigArraysModule(this.settings));
            modules.add((Module)new PluginsModule(this.settings, this.pluginsService));
            modules.add((Module)new SettingsModule(this.settings));
            modules.add((Module)new NodeModule(this));
            modules.add((Module)new NetworkModule());
            modules.add((Module)new ScriptModule(this.settings));
            modules.add((Module)new EnvironmentModule(this.environment));
            modules.add((Module)new NodeEnvironmentModule(nodeEnvironment));
            modules.add((Module)new ClusterNameModule(this.settings));
            modules.add((Module)new ThreadPoolModule(this.settings));
            modules.add((Module)new DiscoveryModule(this.settings));
            modules.add((Module)new ClusterModule(this.settings));
            modules.add((Module)new RestModule(this.settings));
            modules.add((Module)new TransportModule(this.settings));
            if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
                modules.add((Module)new HttpServerModule(this.settings));
            }
            modules.add((Module)new RiversModule(this.settings));
            modules.add((Module)new IndicesModule(this.settings));
            modules.add((Module)new SearchModule());
            modules.add((Module)new ActionModule(false));
            modules.add((Module)new MonitorModule(this.settings));
            modules.add((Module)new GatewayModule(this.settings));
            modules.add((Module)new NodeClientModule());
            modules.add((Module)new BulkUdpModule());
            modules.add((Module)new ShapeModule());
            modules.add((Module)new PercolatorModule());
            modules.add((Module)new ResourceWatcherModule());
            modules.add((Module)new RepositoriesModule());
            modules.add((Module)new TribeModule());
            this.injector = modules.createInjector();
            this.client = this.injector.getInstance(Client.class);
            success = true;
        }
        finally {
            if (!success) {
                nodeEnvironment.close();
            }
        }
        logger.info("initialized", new Object[0]);
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public Node start() {
        if (!this.lifecycle.moveToStarted()) {
            return this;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("starting ...", new Object[0]);
        this.injector.getInstance(Discovery.class).setAllocationService(this.injector.getInstance(AllocationService.class));
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            this.injector.getInstance(plugin).start();
        }
        this.injector.getInstance(MappingUpdatedAction.class).start();
        this.injector.getInstance(IndicesService.class).start();
        this.injector.getInstance(IndexingMemoryController.class).start();
        this.injector.getInstance(IndicesClusterStateService.class).start();
        this.injector.getInstance(IndicesTTLService.class).start();
        this.injector.getInstance(RiversManager.class).start();
        this.injector.getInstance(SnapshotsService.class).start();
        this.injector.getInstance(TransportService.class).start();
        this.injector.getInstance(ClusterService.class).start();
        this.injector.getInstance(RoutingService.class).start();
        this.injector.getInstance(SearchService.class).start();
        this.injector.getInstance(MonitorService.class).start();
        this.injector.getInstance(RestController.class).start();
        DiscoveryService discoService = (DiscoveryService)this.injector.getInstance(DiscoveryService.class).start();
        discoService.waitForInitialState();
        this.injector.getInstance(GatewayService.class).start();
        if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).start();
        }
        this.injector.getInstance(BulkUdpService.class).start();
        this.injector.getInstance(ResourceWatcherService.class).start();
        this.injector.getInstance(TribeService.class).start();
        logger.info("started", new Object[0]);
        return this;
    }

    @Override
    public Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("stopping ...", new Object[0]);
        this.injector.getInstance(TribeService.class).stop();
        this.injector.getInstance(BulkUdpService.class).stop();
        this.injector.getInstance(ResourceWatcherService.class).stop();
        if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).stop();
        }
        this.injector.getInstance(MappingUpdatedAction.class).stop();
        this.injector.getInstance(RiversManager.class).stop();
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(IndexingMemoryController.class).stop();
        this.injector.getInstance(IndicesTTLService.class).stop();
        this.injector.getInstance(IndicesService.class).stop();
        this.injector.getInstance(RoutingService.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(DiscoveryService.class).stop();
        this.injector.getInstance(MonitorService.class).stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(RestController.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            this.injector.getInstance(plugin).stop();
        }
        logger.info("stopped", new Object[0]);
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.moveToClosed()) {
            return;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("closing ...", new Object[0]);
        StopWatch stopWatch = new StopWatch("node_close");
        stopWatch.start("tribe");
        this.injector.getInstance(TribeService.class).close();
        stopWatch.stop().start("bulk.udp");
        this.injector.getInstance(BulkUdpService.class).close();
        stopWatch.stop().start("http");
        if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).close();
        }
        stopWatch.stop().start("rivers");
        this.injector.getInstance(RiversManager.class).close();
        stopWatch.stop().start("snapshot_service");
        this.injector.getInstance(SnapshotsService.class).close();
        stopWatch.stop().start("client");
        Releasables.close(this.injector.getInstance(Client.class));
        stopWatch.stop().start("indices_cluster");
        this.injector.getInstance(IndicesClusterStateService.class).close();
        stopWatch.stop().start("indices");
        this.injector.getInstance(IndicesFilterCache.class).close();
        this.injector.getInstance(IndicesFieldDataCache.class).close();
        this.injector.getInstance(IndexingMemoryController.class).close();
        this.injector.getInstance(IndicesTTLService.class).close();
        this.injector.getInstance(IndicesService.class).close();
        stopWatch.stop().start("routing");
        this.injector.getInstance(RoutingService.class).close();
        stopWatch.stop().start("cluster");
        this.injector.getInstance(ClusterService.class).close();
        stopWatch.stop().start("discovery");
        this.injector.getInstance(DiscoveryService.class).close();
        stopWatch.stop().start("monitor");
        this.injector.getInstance(MonitorService.class).close();
        stopWatch.stop().start("gateway");
        this.injector.getInstance(GatewayService.class).close();
        stopWatch.stop().start("search");
        this.injector.getInstance(SearchService.class).close();
        stopWatch.stop().start("rest");
        this.injector.getInstance(RestController.class).close();
        stopWatch.stop().start("transport");
        this.injector.getInstance(TransportService.class).close();
        stopWatch.stop().start("percolator_service");
        this.injector.getInstance(PercolatorService.class).close();
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.services()) {
            stopWatch.stop().start("plugin(" + plugin.getName() + ")");
            this.injector.getInstance(plugin).close();
        }
        stopWatch.stop().start("script");
        this.injector.getInstance(ScriptService.class).close();
        stopWatch.stop().start("thread_pool");
        this.injector.getInstance(ThreadPool.class).shutdown();
        try {
            this.injector.getInstance(ThreadPool.class).awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        stopWatch.stop().start("thread_pool_force_shutdown");
        try {
            this.injector.getInstance(ThreadPool.class).shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stopWatch.stop();
        if (logger.isTraceEnabled()) {
            logger.trace("Close times for each service:\n{}", stopWatch.prettyPrint());
        }
        this.injector.getInstance(NodeEnvironment.class).close();
        this.injector.getInstance(CacheRecycler.class).close();
        this.injector.getInstance(PageCacheRecycler.class).close();
        Injectors.close(this.injector);
        CachedStreams.clear();
        logger.info("closed", new Object[0]);
    }

    @Override
    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }

    public static void main(String[] args) throws Exception {
        final InternalNode node = new InternalNode();
        node.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                node.close();
            }
        });
    }
}

