/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.index.query.functionscore.FunctionScoreModule;
import org.elasticsearch.index.search.morelikethis.MoreLikeThisFetchService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.TransportSearchModule;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.aggregations.AggregationModule;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.facet.FacetModule;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.explain.ExplainFetchSubPhase;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.matchedqueries.MatchedQueriesFetchSubPhase;
import org.elasticsearch.search.fetch.partial.PartialFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.script.ScriptFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.source.FetchSourceSubPhase;
import org.elasticsearch.search.fetch.version.VersionFetchSubPhase;
import org.elasticsearch.search.highlight.HighlightModule;
import org.elasticsearch.search.highlight.HighlightPhase;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.suggest.SuggestModule;

public class SearchModule
extends AbstractModule
implements SpawnModules {
    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(new TransportSearchModule(), new FacetModule(), new HighlightModule(), new SuggestModule(), new FunctionScoreModule(), new AggregationModule());
    }

    @Override
    protected void configure() {
        this.bind(DfsPhase.class).asEagerSingleton();
        this.bind(QueryPhase.class).asEagerSingleton();
        this.bind(SearchService.class).asEagerSingleton();
        this.bind(SearchPhaseController.class).asEagerSingleton();
        this.bind(FetchPhase.class).asEagerSingleton();
        this.bind(ExplainFetchSubPhase.class).asEagerSingleton();
        this.bind(FieldDataFieldsFetchSubPhase.class).asEagerSingleton();
        this.bind(ScriptFieldsFetchSubPhase.class).asEagerSingleton();
        this.bind(PartialFieldsFetchSubPhase.class).asEagerSingleton();
        this.bind(FetchSourceSubPhase.class).asEagerSingleton();
        this.bind(VersionFetchSubPhase.class).asEagerSingleton();
        this.bind(MatchedQueriesFetchSubPhase.class).asEagerSingleton();
        this.bind(HighlightPhase.class).asEagerSingleton();
        this.bind(SearchServiceTransportAction.class).asEagerSingleton();
        this.bind(MoreLikeThisFetchService.class).asEagerSingleton();
    }
}

