/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.compat.h2;

import com.thinkaurelius.titan.graphdb.configuration.TitanConstants;
import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompat;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.compat.h2.DistCacheConfigurer;
import com.thinkaurelius.titan.hadoop.compat.h2.Hadoop2Compiler;
import com.thinkaurelius.titan.hadoop.compat.h2.ImmutableConfiguration;
import com.thinkaurelius.titan.hadoop.compat.h2.MapredJarConfigurer;
import com.thinkaurelius.titan.hadoop.config.job.JobClasspathConfigurer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.mrunit.mapreduce.MapReduceDriver;

public class Hadoop2Compat
implements HadoopCompat {
    private static final String CFG_SPECULATIVE_MAPS = "mapreduce.map.speculative";
    private static final String CFG_SPECULATIVE_REDUCES = "mapreduce.reduce.speculative";
    private static final String CFG_JOB_JAR = "mapreduce.job.jar";

    public HadoopCompiler newCompiler(HadoopGraph g) {
        return new Hadoop2Compiler(g);
    }

    public TaskAttemptContext newTask(Configuration c, TaskAttemptID t) {
        return new TaskAttemptContextImpl(c, t);
    }

    public String getSpeculativeMapConfigKey() {
        return CFG_SPECULATIVE_MAPS;
    }

    public String getSpeculativeReduceConfigKey() {
        return CFG_SPECULATIVE_REDUCES;
    }

    public String getMapredJarConfigKey() {
        return CFG_JOB_JAR;
    }

    public void incrementContextCounter(TaskInputOutputContext context, Enum<?> counter, long incr) {
        context.getCounter(counter).increment(incr);
    }

    public Configuration getContextConfiguration(TaskAttemptContext context) {
        return context.getConfiguration();
    }

    public long getCounter(MapReduceDriver counters, Enum<?> e) {
        return counters.getCounters().findCounter(e).getValue();
    }

    public JobClasspathConfigurer newMapredJarConfigurer(String mapredJarPath) {
        return new MapredJarConfigurer(mapredJarPath);
    }

    public JobClasspathConfigurer newDistCacheConfigurer() {
        return new DistCacheConfigurer("titan-hadoop-core-" + TitanConstants.VERSION + ".jar");
    }

    public Configuration getJobContextConfiguration(JobContext context) {
        return context.getConfiguration();
    }

    public Configuration newImmutableConfiguration(Configuration base) {
        return new ImmutableConfiguration(base);
    }
}

