/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.impl.Hash;
import org.cache2k.impl.IntegrityState;
import org.cache2k.impl.LockFreeCache;
import org.cache2k.impl.util.TunableConstants;

public class ClockProPlusCache<K, T>
extends LockFreeCache<Entry, K, T> {
    long hotHits;
    long coldHits;
    long ghostHits;
    long directRemoveCnt;
    long hotRunCnt;
    long hot24hCnt;
    long hotScanCnt;
    long evictedColdHitCnt = 0L;
    long hotSizeSum;
    long coldRunCnt;
    long cold24hCnt;
    long coldScanCnt;
    int coldSize;
    int hotSize;
    int staleSize;
    int hotMax;
    int ghostMax;
    Entry handCold;
    Entry handHot;
    Entry handGhost;
    Hash<Entry> ghostHashCtrl;
    Entry[] ghostHash;
    long ghostInsertCnt = 0L;
    Tunable tunable = new Tunable();

    private int sumUpListHits(Entry e) {
        if (e == null) {
            return 0;
        }
        int cnt = 0;
        Entry _head = e;
        do {
            cnt += e.hitCnt;
        } while ((e = (Entry)e.next) != _head);
        return cnt;
    }

    @Override
    public long getHitCnt() {
        return this.hotHits + this.coldHits + (long)this.sumUpListHits(this.handCold) + (long)this.sumUpListHits(this.handHot);
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.ghostMax = this.maxSize;
        this.ghostMax = this.maxSize;
        this.hotMax = this.maxSize * 97 / 100;
        this.coldSize = 0;
        this.hotSize = 0;
        this.staleSize = 0;
        this.handCold = null;
        this.handHot = null;
        this.handGhost = null;
        this.ghostHashCtrl = new Hash();
        this.ghostHash = (Entry[])this.ghostHashCtrl.init(Entry.class);
    }

    @Override
    protected void removeEntryFromReplacementList(Entry e) {
        this.evictedColdHitCnt += (long)e.coldHitCnt;
        this.insertCopyIntoGhosts(e);
        if (this.handCold == e) {
            this.handCold = ClockProPlusCache.removeFromCyclicList(this.handCold, e);
            --this.coldSize;
            ++this.directRemoveCnt;
        } else {
            ++this.staleSize;
            e.setStale();
        }
    }

    private void insertCopyIntoGhosts(Entry e) {
        Entry e2 = new Entry();
        e2.key = e.key;
        e2.hashCode = e.hashCode;
        e2.fetchedTime = this.ghostInsertCnt++;
        this.ghostHash = (Entry[])this.ghostHashCtrl.insert(this.ghostHash, e2);
        this.handGhost = ClockProPlusCache.insertIntoTailCyclicList(this.handGhost, e2);
        if (this.ghostHashCtrl.size > this.ghostMax) {
            this.runHandGhost();
        }
    }

    private int getListSize() {
        return this.hotSize + this.coldSize - this.staleSize;
    }

    @Override
    protected void recordHit(Entry e) {
        ++e.hitCnt;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.coldSize;
        this.handCold = ClockProPlusCache.insertIntoTailCyclicList(this.handCold, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    protected Entry<K, T> runHandHot() {
        Entry _handStart;
        Entry _hand;
        ++this.hotRunCnt;
        Entry _coldCandidate = _hand = (_handStart = this.handHot);
        int _lowestHits = Integer.MAX_VALUE;
        long _hotHits = this.hotHits;
        int _scanCnt = -1;
        int _decrease = 1;
        _decrease = (_hand.hitCnt + ((Entry)_hand.next).hitCnt >> 6) + 1;
        do {
            ++_scanCnt;
            int _hitCnt = _hand.hitCnt;
            if (_hitCnt < _lowestHits) {
                _lowestHits = _hitCnt;
                _coldCandidate = _hand;
                if (_hitCnt == 0) break;
            }
            if (_hitCnt < _decrease) {
                _hand.hitCnt = 0;
                _hotHits += (long)_hitCnt;
                continue;
            }
            _hand.hitCnt = _hitCnt - _decrease;
            _hotHits += (long)_decrease;
        } while ((_hand = (Entry)_hand.next) != _handStart);
        this.hotHits = _hotHits;
        this.hotScanCnt += (long)_scanCnt;
        if (_scanCnt == this.hotMax) {
            ++this.hot24hCnt;
        }
        this.handHot = ClockProPlusCache.removeFromCyclicList(_hand, _coldCandidate);
        --this.hotSize;
        return _coldCandidate;
    }

    @Override
    protected Entry findEvictionCandidate() {
        this.hotSizeSum += (long)this.hotMax;
        ++this.coldRunCnt;
        Entry _hand = this.handCold;
        int _scanCnt = 0;
        while (true) {
            if (_hand == null) {
                _hand = this.refillFromHot(_hand);
            }
            if (_hand.hitCnt > 0) {
                _hand = this.refillFromHot(_hand);
                do {
                    ++_scanCnt;
                    ++_hand.coldHitCnt;
                    this.coldHits += (long)_hand.hitCnt;
                    _hand.hitCnt = 0;
                    Entry e = _hand;
                    _hand = (Entry)ClockProPlusCache.removeFromCyclicList(e);
                    --this.coldSize;
                    ++this.hotSize;
                    this.handHot = ClockProPlusCache.insertIntoTailCyclicList(this.handHot, e);
                } while (_hand != null && _hand.hitCnt > 0);
            }
            if (_hand == null) {
                _hand = this.refillFromHot(_hand);
            }
            if (!_hand.isStale()) break;
            _hand = (Entry)ClockProPlusCache.removeFromCyclicList(_hand);
            --this.staleSize;
            --this.coldSize;
            --_scanCnt;
        }
        if (_scanCnt > this.coldSize) {
            ++this.cold24hCnt;
        }
        this.coldScanCnt += (long)_scanCnt;
        this.handCold = _hand;
        return _hand;
    }

    private Entry<K, T> refillFromHot(Entry<K, T> _hand) {
        while (this.hotSize > this.hotMax || _hand == null) {
            Entry<K, T> e = this.runHandHot();
            if (e == null) continue;
            if (e.isStale()) {
                --this.staleSize;
                continue;
            }
            _hand = ClockProPlusCache.insertIntoTailCyclicList(_hand, e);
            ++this.coldSize;
        }
        return _hand;
    }

    protected void runHandGhost() {
        boolean f = this.ghostHashCtrl.remove(this.ghostHash, this.handGhost);
        Entry e = this.handGhost;
        this.handGhost = (Entry)ClockProPlusCache.removeFromCyclicList(this.handGhost);
    }

    @Override
    protected Entry checkForGhost(K key, int hc) {
        Entry e = (Entry)this.ghostHashCtrl.remove(this.ghostHash, key, hc);
        if (e != null) {
            this.handGhost = ClockProPlusCache.removeFromCyclicList(this.handGhost, e);
            ++this.ghostHits;
            ++this.hotSize;
            this.handHot = ClockProPlusCache.insertIntoTailCyclicList(this.handHot, e);
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return super.getIntegrityState().checkEquals("ghostHashCtrl.size == Hash.calcEntryCount(refreshHash)", this.ghostHashCtrl.size, Hash.calcEntryCount(this.ghostHash)).check("hotMax <= maxElements", this.hotMax <= this.maxSize).checkEquals("getListSize() == getSize()", this.getListSize(), this.getLocalSize()).check("checkCyclicListIntegrity(handHot)", ClockProPlusCache.checkCyclicListIntegrity(this.handHot)).check("checkCyclicListIntegrity(handCold)", ClockProPlusCache.checkCyclicListIntegrity(this.handCold)).check("checkCyclicListIntegrity(handGhost)", ClockProPlusCache.checkCyclicListIntegrity(this.handGhost)).checkEquals("getCyclicListEntryCount(handHot) == hotSize", ClockProPlusCache.getCyclicListEntryCount(this.handHot), this.hotSize).checkEquals("getCyclicListEntryCount(handCold) == coldSize", ClockProPlusCache.getCyclicListEntryCount(this.handCold), this.coldSize).checkEquals("getCyclicListEntryCount(handGhost) == ghostSize", ClockProPlusCache.getCyclicListEntryCount(this.handGhost), this.ghostHashCtrl.size);
        }
    }

    @Override
    protected String getExtraStatistics() {
        return ", coldSize=" + this.coldSize + ", hotSize=" + this.hotSize + ", hotMaxSize=" + this.hotMax + ", hotSizeAvg=" + (this.coldRunCnt > 0L ? this.hotSizeSum / this.coldRunCnt : -1L) + ", ghostSize=" + this.ghostHashCtrl.size + ", staleSize=" + this.staleSize + ", coldHits=" + (this.coldHits + (long)this.sumUpListHits(this.handCold)) + ", hotHits=" + (this.hotHits + (long)this.sumUpListHits(this.handHot)) + ", ghostHits=" + this.ghostHits + ", coldRunCnt=" + this.coldRunCnt + ", coldScanCnt=" + this.coldScanCnt + ", cold24hCnt=" + this.cold24hCnt + ", hotRunCnt=" + this.hotRunCnt + ", hotScanCnt=" + this.hotScanCnt + ", hot24hCnt=" + this.hot24hCnt + ", directRemoveCnt=" + this.directRemoveCnt;
    }

    public int getHotMax() {
        return this.hotMax;
    }

    public void setHotMax(int hotMax) {
        this.hotMax = hotMax;
    }

    public static class Tunable
    extends TunableConstants {
        public boolean insert0HitsFromHotToColdHead = false;
    }

    static class Entry<K, T>
    extends org.cache2k.impl.Entry<Entry, K, T> {
        int hitCnt;
        int coldHitCnt;

        Entry() {
        }
    }
}

