/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.security.KerberosInfo;
import org.apache.hadoop.hbase.security.TokenInfo;
import org.apache.hadoop.hbase.util.Pair;

@KerberosInfo(serverPrincipal="hbase.regionserver.kerberos.principal")
@TokenInfo(value="HBASE_AUTH_TOKEN")
public interface HRegionInterface
extends VersionedProtocol,
Stoppable,
Abortable {
    public static final long VERSION = 29L;

    public HRegionInfo getRegionInfo(byte[] var1) throws NotServingRegionException, ConnectException, IOException;

    public void flushRegion(byte[] var1) throws IllegalArgumentException, IOException;

    public void flushRegion(byte[] var1, long var2) throws IllegalArgumentException, IOException;

    public long getLastFlushTime(byte[] var1);

    public List<String> getStoreFileList(byte[] var1, byte[] var2) throws IllegalArgumentException;

    public List<String> getStoreFileList(byte[] var1, byte[][] var2) throws IllegalArgumentException;

    public List<String> getStoreFileList(byte[] var1) throws IllegalArgumentException;

    public Result getClosestRowBefore(byte[] var1, byte[] var2, byte[] var3) throws IOException;

    public Result get(byte[] var1, Get var2) throws IOException;

    public boolean exists(byte[] var1, Get var2) throws IOException;

    public void put(byte[] var1, Put var2) throws IOException;

    public int put(byte[] var1, List<Put> var2) throws IOException;

    public void delete(byte[] var1, Delete var2) throws IOException;

    public int delete(byte[] var1, List<Delete> var2) throws IOException;

    public boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, Put var6) throws IOException;

    public boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, Delete var6) throws IOException;

    public long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, byte[] var4, long var5, boolean var7) throws IOException;

    public void mutateRow(byte[] var1, RowMutations var2) throws IOException;

    public Result append(byte[] var1, Append var2) throws IOException;

    public Result increment(byte[] var1, Increment var2) throws IOException;

    public long openScanner(byte[] var1, Scan var2) throws IOException;

    public Result next(long var1) throws IOException;

    public Result[] next(long var1, int var3) throws IOException;

    public void close(long var1) throws IOException;

    public long lockRow(byte[] var1, byte[] var2) throws IOException;

    public void unlockRow(byte[] var1, long var2) throws IOException;

    public List<HRegionInfo> getOnlineRegions() throws IOException;

    public HServerInfo getHServerInfo() throws IOException;

    public <R> MultiResponse multi(MultiAction<R> var1) throws IOException;

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> var1, byte[] var2) throws IOException;

    public RegionOpeningState openRegion(HRegionInfo var1) throws IOException;

    public RegionOpeningState openRegion(HRegionInfo var1, int var2) throws IOException;

    public void openRegions(List<HRegionInfo> var1) throws IOException;

    public boolean closeRegion(HRegionInfo var1) throws IOException;

    public boolean closeRegion(HRegionInfo var1, int var2) throws IOException;

    public boolean closeRegion(HRegionInfo var1, boolean var2) throws IOException;

    public boolean closeRegion(byte[] var1, boolean var2) throws IOException;

    public void flushRegion(HRegionInfo var1) throws NotServingRegionException, IOException;

    public void splitRegion(HRegionInfo var1) throws NotServingRegionException, IOException;

    public void splitRegion(HRegionInfo var1, byte[] var2) throws NotServingRegionException, IOException;

    public void compactRegion(HRegionInfo var1, boolean var2) throws NotServingRegionException, IOException;

    public void compactRegion(HRegionInfo var1, boolean var2, byte[] var3) throws NotServingRegionException, IOException;

    public void replicateLogEntries(HLog.Entry[] var1) throws IOException;

    public ExecResult execCoprocessor(byte[] var1, Exec var2) throws IOException;

    public boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, byte[] var4, CompareFilter.CompareOp var5, WritableByteArrayComparable var6, Put var7) throws IOException;

    public boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, byte[] var4, CompareFilter.CompareOp var5, WritableByteArrayComparable var6, Delete var7) throws IOException;

    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries() throws IOException;

    public byte[][] rollHLogWriter() throws IOException, FailedLogCloseException;

    public String getCompactionState(byte[] var1) throws IOException;

    @Override
    public void stop(String var1);
}

