/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.thrift.IterInfo;

public class ActiveCompactionImpl
extends ActiveCompaction {
    private org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac;
    private Instance instance;

    ActiveCompactionImpl(Instance instance, org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction tac) {
        this.tac = tac;
        this.instance = instance;
    }

    @Override
    public String getTable() throws TableNotFoundException {
        return Tables.getTableName(this.instance, this.getExtent().getTableId().toString());
    }

    @Override
    public KeyExtent getExtent() {
        return new KeyExtent(this.tac.getExtent());
    }

    @Override
    public long getAge() {
        return this.tac.getAge();
    }

    @Override
    public List<String> getInputFiles() {
        return this.tac.getInputFiles();
    }

    @Override
    public String getOutputFile() {
        return this.tac.getOutputFile();
    }

    @Override
    public ActiveCompaction.CompactionType getType() {
        return ActiveCompaction.CompactionType.valueOf(this.tac.getType().name());
    }

    @Override
    public ActiveCompaction.CompactionReason getReason() {
        return ActiveCompaction.CompactionReason.valueOf(this.tac.getReason().name());
    }

    @Override
    public String getLocalityGroup() {
        return this.tac.getLocalityGroup();
    }

    @Override
    public long getEntriesRead() {
        return this.tac.getEntriesRead();
    }

    @Override
    public long getEntriesWritten() {
        return this.tac.getEntriesWritten();
    }

    @Override
    public List<IteratorSetting> getIterators() {
        ArrayList<IteratorSetting> ret = new ArrayList<IteratorSetting>();
        for (IterInfo ii : this.tac.getSsiList()) {
            IteratorSetting settings = new IteratorSetting(ii.getPriority(), ii.getIterName(), ii.getClassName());
            Map<String, String> options = this.tac.getSsio().get(ii.getIterName());
            settings.addOptions(options);
            ret.add(settings);
        }
        return ret;
    }
}

