/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchDeleter;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.SecurityOperations;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.impl.BatchWriterImpl;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ConditionalWriterImpl;
import org.apache.accumulo.core.client.impl.InstanceOperationsImpl;
import org.apache.accumulo.core.client.impl.MultiTableBatchWriterImpl;
import org.apache.accumulo.core.client.impl.NamespaceOperationsImpl;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.SecurityOperationsImpl;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.TableOperationsImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletServerBatchDeleter;
import org.apache.accumulo.core.client.impl.TabletServerBatchReader;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.trace.instrument.Tracer;

public class ConnectorImpl
extends Connector {
    private final Instance instance;
    private final Credentials credentials;
    private SecurityOperations secops = null;
    private TableOperations tableops = null;
    private NamespaceOperations namespaceops = null;
    private InstanceOperations instanceops = null;

    public ConnectorImpl(final Instance instance, Credentials cred) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(instance, cred);
        if (cred.getToken().isDestroyed()) {
            throw new AccumuloSecurityException(cred.getPrincipal(), SecurityErrorCode.TOKEN_EXPIRED);
        }
        this.instance = instance;
        this.credentials = cred;
        if (!"org.apache.accumulo.server.security.SystemCredentials$SystemToken".equals(cred.getToken().getClass().getName())) {
            ServerClient.execute(instance, new ClientExec<ClientService.Client>(){

                @Override
                public void execute(ClientService.Client iface) throws Exception {
                    if (!iface.authenticate(Tracer.traceInfo(), ConnectorImpl.this.credentials.toThrift(instance))) {
                        throw new AccumuloSecurityException("Authentication failed, access denied", SecurityErrorCode.BAD_CREDENTIALS);
                    }
                }
            });
        }
        this.tableops = new TableOperationsImpl(instance, this.credentials);
        this.namespaceops = new NamespaceOperationsImpl(instance, this.credentials, (TableOperationsImpl)this.tableops);
    }

    private String getTableId(String tableName) throws TableNotFoundException {
        String tableId = Tables.getTableId(this.instance, tableName);
        if (Tables.getTableState(this.instance, tableId) == TableState.OFFLINE) {
            throw new TableOfflineException(this.instance, tableId);
        }
        return tableId;
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public BatchScanner createBatchScanner(String tableName, Authorizations authorizations, int numQueryThreads) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new TabletServerBatchReader(this.instance, this.credentials, this.getTableId(tableName), authorizations, numQueryThreads);
    }

    @Override
    @Deprecated
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new TabletServerBatchDeleter(this.instance, this.credentials, this.getTableId(tableName), authorizations, numQueryThreads, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchDeleter createBatchDeleter(String tableName, Authorizations authorizations, int numQueryThreads, BatchWriterConfig config) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new TabletServerBatchDeleter(this.instance, this.credentials, this.getTableId(tableName), authorizations, numQueryThreads, config);
    }

    @Override
    @Deprecated
    public BatchWriter createBatchWriter(String tableName, long maxMemory, long maxLatency, int maxWriteThreads) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        return new BatchWriterImpl(this.instance, this.credentials, this.getTableId(tableName), new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public BatchWriter createBatchWriter(String tableName, BatchWriterConfig config) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName);
        return new BatchWriterImpl(this.instance, this.credentials, this.getTableId(tableName), config);
    }

    @Override
    @Deprecated
    public MultiTableBatchWriter createMultiTableBatchWriter(long maxMemory, long maxLatency, int maxWriteThreads) {
        return new MultiTableBatchWriterImpl(this.instance, this.credentials, new BatchWriterConfig().setMaxMemory(maxMemory).setMaxLatency(maxLatency, TimeUnit.MILLISECONDS).setMaxWriteThreads(maxWriteThreads));
    }

    @Override
    public MultiTableBatchWriter createMultiTableBatchWriter(BatchWriterConfig config) {
        return new MultiTableBatchWriterImpl(this.instance, this.credentials, config);
    }

    @Override
    public ConditionalWriter createConditionalWriter(String tableName, ConditionalWriterConfig config) throws TableNotFoundException {
        return new ConditionalWriterImpl(this.instance, this.credentials, this.getTableId(tableName), config);
    }

    @Override
    public Scanner createScanner(String tableName, Authorizations authorizations) throws TableNotFoundException {
        ArgumentChecker.notNull(tableName, authorizations);
        return new ScannerImpl(this.instance, this.credentials, this.getTableId(tableName), authorizations);
    }

    @Override
    public String whoami() {
        return this.credentials.getPrincipal();
    }

    @Override
    public synchronized TableOperations tableOperations() {
        return this.tableops;
    }

    @Override
    public synchronized NamespaceOperations namespaceOperations() {
        return this.namespaceops;
    }

    @Override
    public synchronized SecurityOperations securityOperations() {
        if (this.secops == null) {
            this.secops = new SecurityOperationsImpl(this.instance, this.credentials);
        }
        return this.secops;
    }

    @Override
    public synchronized InstanceOperations instanceOperations() {
        if (this.instanceops == null) {
            this.instanceops = new InstanceOperationsImpl(this.instance, this.credentials);
        }
        return this.instanceops;
    }
}

