/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.impl.TabletLocatorImpl;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.util.OpTimer;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class RootTabletLocator
extends TabletLocator {
    private final Instance instance;
    private final TabletLocatorImpl.TabletServerLockChecker lockChecker;
    private final ZooCacheFactory zcf;

    RootTabletLocator(Instance instance, TabletLocatorImpl.TabletServerLockChecker lockChecker) {
        this(instance, lockChecker, new ZooCacheFactory());
    }

    RootTabletLocator(Instance instance, TabletLocatorImpl.TabletServerLockChecker lockChecker, ZooCacheFactory zcf) {
        this.instance = instance;
        this.lockChecker = lockChecker;
        this.zcf = zcf;
    }

    @Override
    public <T extends Mutation> void binMutations(Credentials credentials, List<T> mutations, Map<String, TabletLocator.TabletServerMutations<T>> binnedMutations, List<T> failures) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation rootTabletLocation = this.getRootTabletLocation();
        if (rootTabletLocation != null) {
            TabletLocator.TabletServerMutations<Mutation> tsm = new TabletLocator.TabletServerMutations<Mutation>(rootTabletLocation.tablet_session);
            for (Mutation mutation : mutations) {
                tsm.addMutation(RootTable.EXTENT, mutation);
            }
            binnedMutations.put(rootTabletLocation.tablet_location, tsm);
        } else {
            failures.addAll(mutations);
        }
    }

    @Override
    public List<Range> binRanges(Credentials credentials, List<Range> ranges, Map<String, Map<KeyExtent, List<Range>>> binnedRanges) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation rootTabletLocation = this.getRootTabletLocation();
        if (rootTabletLocation != null) {
            for (Range range : ranges) {
                TabletLocatorImpl.addRange(binnedRanges, rootTabletLocation.tablet_location, RootTable.EXTENT, range);
            }
            return Collections.emptyList();
        }
        return ranges;
    }

    @Override
    public void invalidateCache(KeyExtent failedExtent) {
    }

    @Override
    public void invalidateCache(Collection<KeyExtent> keySet) {
    }

    @Override
    public void invalidateCache(String server) {
        ZooCache zooCache = this.zcf.getZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut());
        String root = ZooUtil.getRoot(this.instance) + "/tservers";
        zooCache.clear(root + "/" + server);
    }

    @Override
    public void invalidateCache() {
    }

    protected TabletLocator.TabletLocation getRootTabletLocation() {
        String zRootLocPath = ZooUtil.getRoot(this.instance) + "/root_tablet/location";
        ZooCache zooCache = this.zcf.getZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut());
        OpTimer opTimer = new OpTimer(Logger.getLogger(this.getClass()), Level.TRACE).start("Looking up root tablet location in zookeeper.");
        byte[] loc = zooCache.get(zRootLocPath);
        opTimer.stop("Found root tablet at " + (loc == null ? null : new String(loc)) + " in %DURATION%");
        if (loc == null) {
            return null;
        }
        String[] tokens = new String(loc).split("\\|");
        if (this.lockChecker.isLockHeld(tokens[0], tokens[1])) {
            return new TabletLocator.TabletLocation(RootTable.EXTENT, tokens[0], tokens[1]);
        }
        return null;
    }

    @Override
    public TabletLocator.TabletLocation locateTablet(Credentials credentials, Text row, boolean skipRow, boolean retry) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        TabletLocator.TabletLocation location = this.getRootTabletLocation();
        while (retry && location == null) {
            UtilWaitThread.sleep(500L);
            location = this.getRootTabletLocation();
        }
        return location;
    }
}

