/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.conf;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.Property;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class SiteConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(SiteConfiguration.class);
    private static AccumuloConfiguration parent = null;
    private static SiteConfiguration instance = null;
    private static Configuration xmlConfig;

    SiteConfiguration(AccumuloConfiguration parent) {
        SiteConfiguration.parent = parent;
    }

    public static synchronized SiteConfiguration getInstance(AccumuloConfiguration parent) {
        if (instance == null) {
            instance = new SiteConfiguration(parent);
            ConfigSanityCheck.validate(instance);
        }
        return instance;
    }

    private static synchronized Configuration getXmlConfig() {
        String configFile = System.getProperty("org.apache.accumulo.config.file", "accumulo-site.xml");
        if (xmlConfig == null) {
            xmlConfig = new Configuration(false);
            if (SiteConfiguration.class.getClassLoader().getResource(configFile) == null) {
                log.warn((Object)(configFile + " not found on classpath"), new Throwable());
            } else {
                xmlConfig.addResource(configFile);
            }
        }
        return xmlConfig;
    }

    @Override
    public String get(Property property) {
        String value;
        Configuration hadoopConf;
        String key = property.getKey();
        if (property.isSensitive() && null != (hadoopConf = this.getHadoopConfiguration())) {
            try {
                char[] value2 = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key);
                if (null != value2) {
                    return new String(value2);
                }
            }
            catch (IOException e) {
                log.warn((Object)("Failed to extract sensitive property (" + key + ") from Hadoop CredentialProvider, falling back to accumulo-site.xml"), (Throwable)e);
            }
        }
        if ((value = SiteConfiguration.getXmlConfig().get(key)) == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + (Object)((Object)property.getType()) + ": " + value));
            }
            value = parent.get(property);
        }
        return value;
    }

    @Override
    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        parent.getProperties(props, filter);
        for (Map.Entry entry : SiteConfiguration.getXmlConfig()) {
            if (!filter.accept((String)entry.getKey())) continue;
            props.put((String)entry.getKey(), (String)entry.getValue());
        }
        Configuration hadoopConf = this.getHadoopConfiguration();
        if (null != hadoopConf) {
            try {
                for (String key : CredentialProviderFactoryShim.getKeys(hadoopConf)) {
                    char[] value;
                    if (!Property.isValidPropertyKey(key) || !Property.isSensitive(key) || !filter.accept(key) || null == (value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key))) continue;
                    props.put(key, new String(value));
                }
            }
            catch (IOException e) {
                log.warn((Object)"Failed to extract sensitive properties from Hadoop CredentialProvider, falling back to accumulo-site.xml", (Throwable)e);
            }
        }
    }

    protected Configuration getHadoopConfiguration() {
        String credProviderPathsKey = Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey();
        String credProviderPathsValue = SiteConfiguration.getXmlConfig().get(credProviderPathsKey);
        if (null != credProviderPathsValue) {
            Configuration conf = new Configuration();
            conf.set("hadoop.security.credential.provider.path", credProviderPathsValue);
            return conf;
        }
        return null;
    }

    public static synchronized void clearInstance() {
        instance = null;
    }

    public void clear() {
        SiteConfiguration.getXmlConfig().clear();
    }

    public synchronized void clearAndNull() {
        if (xmlConfig != null) {
            xmlConfig.clear();
            xmlConfig = null;
        }
    }

    public void set(Property property, String value) {
        this.set(property.getKey(), value);
    }

    public void set(String key, String value) {
        SiteConfiguration.getXmlConfig().set(key, value);
    }
}

