/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;

public class JSONUtils {
    protected static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory((ObjectCodec)JSON_MAPPER);
    private static volatile HttpClient httpClient;

    public static Object fromString(String jsonString) throws JsonParseException, IOException {
        return JSONUtils.fromReader(new StringReader(jsonString));
    }

    public static Object fromReader(Reader r) throws IOException {
        JsonParser jp = JSON_FACTORY.createParser(r);
        Object rval = null;
        JsonToken initialToken = jp.nextToken();
        if (initialToken == JsonToken.START_ARRAY) {
            rval = jp.readValueAs(List.class);
        } else if (initialToken == JsonToken.START_OBJECT) {
            rval = jp.readValueAs(Map.class);
        } else if (initialToken == JsonToken.VALUE_STRING) {
            rval = jp.readValueAs(String.class);
        } else if (initialToken == JsonToken.VALUE_FALSE || initialToken == JsonToken.VALUE_TRUE) {
            rval = jp.readValueAs(Boolean.class);
        } else if (initialToken == JsonToken.VALUE_NUMBER_FLOAT || initialToken == JsonToken.VALUE_NUMBER_INT) {
            rval = jp.readValueAs(Number.class);
        } else if (initialToken == JsonToken.VALUE_NULL) {
            rval = null;
        } else {
            throw new JsonParseException("document doesn't start with a valid json element : " + initialToken, jp.getCurrentLocation());
        }
        return rval;
    }

    public static void write(Writer w, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(w);
        jw.writeObject(jsonObject);
    }

    public static void writePrettyPrint(Writer w, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(w);
        jw.useDefaultPrettyPrinter();
        jw.writeObject(jsonObject);
    }

    public static Object fromInputStream(InputStream content) throws IOException {
        return JSONUtils.fromInputStream(content, "UTF-8");
    }

    public static Object fromInputStream(InputStream content, String enc) throws IOException {
        return JSONUtils.fromReader(new BufferedReader(new InputStreamReader(content, enc)));
    }

    public static String toPrettyString(Object obj) {
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.writePrettyPrint(sw, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public static String toString(Object obj) {
        StringWriter sw = new StringWriter();
        try {
            JSONUtils.write(sw, obj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromURL(URL url) throws JsonParseException, IOException {
        InputStream in = null;
        try {
            Object object;
            in = JSONUtils.openStreamFromURL(url);
            JsonParser parser = JSON_FACTORY.createParser(in);
            JsonToken token = parser.nextToken();
            Class type = token == JsonToken.START_OBJECT ? Map.class : (token == JsonToken.START_ARRAY ? List.class : String.class);
            try {
                object = parser.readValueAs(type);
            }
            catch (Throwable throwable) {
                parser.close();
                throw throwable;
            }
            parser.close();
            return object;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static InputStream openStreamFromURL(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
            return url.openStream();
        }
        HttpGet request = new HttpGet(url.toExternalForm());
        request.addHeader("Accept", ACCEPT_HEADER);
        HttpResponse response = JSONUtils.getHttpClient().execute((HttpUriRequest)request);
        int status = response.getStatusLine().getStatusCode();
        if (status != 200 && status != 203) {
            throw new IOException("Can't retrieve " + url + ", status code: " + status);
        }
        return response.getEntity().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static HttpClient getHttpClient() {
        if (httpClient != null) return httpClient;
        Class<JSONUtils> clazz = JSONUtils.class;
        synchronized (JSONUtils.class) {
            if (httpClient != null) return httpClient;
            SystemDefaultHttpClient client = new SystemDefaultHttpClient();
            client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
            client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
            CacheConfig cacheConfig = new CacheConfig();
            cacheConfig.setMaxObjectSize(131072L);
            cacheConfig.setMaxCacheEntries(1000);
            httpClient = new CachingHttpClient((HttpClient)client, cacheConfig);
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setHttpClient(HttpClient nextHttpClient) {
        Class<JSONUtils> clazz = JSONUtils.class;
        synchronized (JSONUtils.class) {
            httpClient = nextHttpClient;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    }
}

