/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.vertex;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.QueryDescription;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertex;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.query.BackendQueryHolder;
import com.thinkaurelius.titan.graphdb.query.QueryProcessor;
import com.thinkaurelius.titan.graphdb.query.QueryUtil;
import com.thinkaurelius.titan.graphdb.query.ResultMergeSortIterator;
import com.thinkaurelius.titan.graphdb.query.ResultSetIterator;
import com.thinkaurelius.titan.graphdb.query.StandardQueryDescription;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.condition.And;
import com.thinkaurelius.titan.graphdb.query.condition.Condition;
import com.thinkaurelius.titan.graphdb.query.condition.DirectionCondition;
import com.thinkaurelius.titan.graphdb.query.condition.IncidenceCondition;
import com.thinkaurelius.titan.graphdb.query.condition.Or;
import com.thinkaurelius.titan.graphdb.query.condition.PredicateCondition;
import com.thinkaurelius.titan.graphdb.query.condition.RelationTypeCondition;
import com.thinkaurelius.titan.graphdb.query.condition.VisibilityFilterCondition;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.BaseVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.query.vertex.SimpleVertexQueryProcessor;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexArrayList;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexCentricQuery;
import com.thinkaurelius.titan.graphdb.query.vertex.VertexListInternal;
import com.thinkaurelius.titan.graphdb.relations.StandardProperty;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.thinkaurelius.titan.graphdb.types.system.SystemRelationType;
import com.thinkaurelius.titan.util.datastructures.Interval;
import com.thinkaurelius.titan.util.datastructures.PointInterval;
import com.thinkaurelius.titan.util.datastructures.RangeInterval;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicVertexCentricQueryBuilder<Q extends BaseVertexQuery<Q>>
extends BaseVertexCentricQueryBuilder<Q> {
    private static final Logger log = LoggerFactory.getLogger(BasicVertexCentricQueryBuilder.class);
    protected final StandardTitanTx tx;
    private boolean querySystem = false;
    private boolean queryOnlyLoaded = false;
    private boolean restrict2Partitions = true;
    private static final int HARD_MAX_LIMIT = 300000;

    public BasicVertexCentricQueryBuilder(StandardTitanTx tx) {
        super(tx);
        Preconditions.checkArgument((tx != null ? 1 : 0) != 0);
        this.tx = tx;
    }

    @Override
    public TitanVertex getVertex(long vertexid) {
        return this.tx.getVertex(vertexid);
    }

    public Q noPartitionRestriction() {
        this.restrict2Partitions = false;
        return this.getThis();
    }

    public Q system() {
        this.querySystem = true;
        return this.getThis();
    }

    public Q queryOnlyLoaded() {
        this.queryOnlyLoaded = true;
        return this.getThis();
    }

    private boolean hasAllCanonicalTypes() {
        for (String typeName : this.types) {
            InternalRelationType type = QueryUtil.getType(this.tx, typeName);
            if (type == null || type.getMultiplicity().isUnique(this.dir)) continue;
            return false;
        }
        return true;
    }

    protected static Iterable<TitanVertex> edges2Vertices(Iterable<TitanEdge> edges, final TitanVertex other) {
        return Iterables.transform(edges, (Function)new Function<TitanEdge, TitanVertex>(){

            @Nullable
            public TitanVertex apply(@Nullable TitanEdge titanEdge) {
                return titanEdge.getOtherVertex(other);
            }
        });
    }

    protected VertexList edges2VertexIds(Iterable<TitanEdge> edges, TitanVertex other) {
        VertexArrayList vertices = new VertexArrayList(this.tx);
        for (TitanEdge edge : edges) {
            vertices.add(edge.getOtherVertex(other));
        }
        return vertices;
    }

    protected Iterable<TitanRelation> executeImplicitKeyQuery(InternalVertex v) {
        assert (this.isImplicitKeyQuery(RelationCategory.PROPERTY));
        if (this.dir == Direction.IN || this.limit < 1) {
            return ImmutableList.of();
        }
        ImplicitKey key = (ImplicitKey)this.tx.getRelationType(this.types[0]);
        return ImmutableList.of((Object)new StandardProperty(0L, key, v, key.computeProperty(v), v.isNew() ? (byte)1 : 2));
    }

    protected List<InternalVertex> allRepresentatives(InternalVertex partitionedVertex) {
        if (this.hasAllCanonicalTypes()) {
            return ImmutableList.of((Object)this.tx.getCanonicalVertex(partitionedVertex));
        }
        return Arrays.asList(this.tx.getAllRepresentatives(partitionedVertex, this.restrict2Partitions));
    }

    protected final boolean isPartitionedVertex(InternalVertex vertex) {
        return this.tx.isPartitionedVertex(vertex);
    }

    protected boolean useSimpleQueryProcessor(BaseVertexCentricQuery query, InternalVertex ... vertices) {
        assert (vertices.length > 0);
        if (!query.isSimple()) {
            return false;
        }
        if (this.queryOnlyLoaded) {
            return true;
        }
        for (InternalVertex vertex : vertices) {
            if (vertex.isLoaded()) continue;
            return false;
        }
        return true;
    }

    protected Iterable<TitanRelation> executeRelations(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        if (this.isPartitionedVertex(vertex)) {
            if (!this.hasAllCanonicalTypes()) {
                InternalVertex[] representatives = this.tx.getAllRepresentatives(vertex, this.restrict2Partitions);
                Iterable<TitanElement> merge = null;
                for (InternalVertex rep : representatives) {
                    Iterable<TitanRelation> iter = this.executeIndividualRelations(rep, baseQuery);
                    merge = merge == null ? iter : ResultMergeSortIterator.mergeSort(merge, iter, this.orders, false);
                }
                return ResultSetIterator.wrap(merge, baseQuery.getLimit());
            }
            vertex = this.tx.getCanonicalVertex(vertex);
        }
        return this.executeIndividualRelations(vertex, baseQuery);
    }

    private Iterable<TitanRelation> executeIndividualRelations(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        VertexCentricQuery query = this.constructQuery(vertex, baseQuery);
        if (this.useSimpleQueryProcessor(query, vertex)) {
            return new SimpleVertexQueryProcessor(query, this.tx).relations();
        }
        return new QueryProcessor<VertexCentricQuery, TitanRelation, SliceQuery>(query, this.tx.edgeProcessor);
    }

    public Iterable<TitanVertex> executeVertices(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        if (this.isPartitionedVertex(vertex)) {
            if (!this.orders.isEmpty()) {
                return this.edges2VertexIds(this.executeRelations(vertex, baseQuery), vertex);
            }
            if (!this.hasAllCanonicalTypes()) {
                InternalVertex[] representatives = this.tx.getAllRepresentatives(vertex, this.restrict2Partitions);
                Iterable<TitanVertex> merge = null;
                for (InternalVertex rep : representatives) {
                    Iterable<TitanVertex> iter = this.executeIndividualVertices(rep, baseQuery);
                    merge = merge == null ? iter : ResultMergeSortIterator.mergeSort(merge, iter, VertexArrayList.VERTEX_ID_COMPARATOR, false);
                }
                return ResultSetIterator.wrap(merge, baseQuery.getLimit());
            }
            vertex = this.tx.getCanonicalVertex(vertex);
        }
        return this.executeIndividualVertices(vertex, baseQuery);
    }

    private Iterable<TitanVertex> executeIndividualVertices(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        VertexCentricQuery query = this.constructQuery(vertex, baseQuery);
        if (this.useSimpleQueryProcessor(query, vertex)) {
            return new SimpleVertexQueryProcessor(query, this.tx).vertexIds();
        }
        return BasicVertexCentricQueryBuilder.edges2Vertices(this.executeIndividualRelations(vertex, baseQuery), query.getVertex());
    }

    public VertexList executeVertexIds(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        if (this.isPartitionedVertex(vertex)) {
            if (!this.orders.isEmpty()) {
                return this.edges2VertexIds(this.executeRelations(vertex, baseQuery), vertex);
            }
            if (!this.hasAllCanonicalTypes()) {
                InternalVertex[] representatives = this.tx.getAllRepresentatives(vertex, this.restrict2Partitions);
                VertexList merge = null;
                for (InternalVertex rep : representatives) {
                    if (merge != null && merge.size() >= baseQuery.getLimit()) break;
                    VertexList vlist = this.executeIndividualVertexIds(rep, baseQuery);
                    if (merge == null) {
                        merge = (VertexListInternal)vlist;
                        continue;
                    }
                    merge.addAll(vlist);
                }
                if (merge.size() > baseQuery.getLimit()) {
                    merge = (VertexListInternal)merge.subList(0, baseQuery.getLimit());
                }
                return merge;
            }
            vertex = this.tx.getCanonicalVertex(vertex);
        }
        return this.executeIndividualVertexIds(vertex, baseQuery);
    }

    private VertexList executeIndividualVertexIds(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        VertexCentricQuery query = this.constructQuery(vertex, baseQuery);
        if (this.useSimpleQueryProcessor(query, vertex)) {
            return new SimpleVertexQueryProcessor(query, this.tx).vertexIds();
        }
        return this.edges2VertexIds(this.executeIndividualRelations(vertex, baseQuery), vertex);
    }

    @Override
    public QueryDescription describeForEdges() {
        return this.describe(1, RelationCategory.EDGE);
    }

    @Override
    public QueryDescription describeForProperties() {
        return this.describe(1, RelationCategory.PROPERTY);
    }

    public QueryDescription describeForRelations() {
        return this.describe(1, RelationCategory.RELATION);
    }

    protected QueryDescription describe(int numVertices, RelationCategory returnType) {
        return new StandardQueryDescription(numVertices, this.constructQuery(returnType));
    }

    protected VertexCentricQuery constructQuery(InternalVertex vertex, BaseVertexCentricQuery baseQuery) {
        Condition<TitanRelation> condition = baseQuery.getCondition();
        if (!baseQuery.isEmpty()) {
            And<TitanRelation> newcond = new And<TitanRelation>();
            if (condition instanceof And) {
                newcond.addAll((And)condition);
            } else {
                newcond.add(condition);
            }
            newcond.add(new DirectionCondition(vertex, this.dir));
            if (this.adjacentVertex != null) {
                newcond.add(new IncidenceCondition(vertex, this.adjacentVertex));
            }
            condition = newcond;
        }
        VertexCentricQuery query = new VertexCentricQuery(vertex, condition, baseQuery.getDirection(), baseQuery.getQueries(), baseQuery.getOrders(), baseQuery.getLimit());
        Preconditions.checkArgument((!this.queryOnlyLoaded || query.isSimple() ? 1 : 0) != 0, (Object)"Query-only-loaded only works on simple queries");
        return query;
    }

    protected BaseVertexCentricQuery constructQuery(RelationCategory returnType) {
        ImmutableList queries;
        assert (returnType != null);
        Preconditions.checkArgument((this.adjacentVertex == null || returnType == RelationCategory.EDGE ? 1 : 0) != 0, (Object)"Vertex constraints only apply to edges");
        if (this.limit <= 0) {
            return BaseVertexCentricQuery.emptyQuery();
        }
        if (returnType == RelationCategory.PROPERTY) {
            if (this.dir == Direction.IN) {
                return BaseVertexCentricQuery.emptyQuery();
            }
            this.dir = Direction.OUT;
        }
        this.orders.makeImmutable();
        assert (this.orders.hasCommonOrder());
        And<TitanRelation> conditions = QueryUtil.constraints2QNF(this.tx, this.constraints);
        if (conditions == null) {
            return BaseVertexCentricQuery.emptyQuery();
        }
        int sliceLimit = this.limit;
        EdgeSerializer serializer = this.tx.getEdgeSerializer();
        if (!this.hasTypes()) {
            BackendQueryHolder<SliceQuery> query = new BackendQueryHolder<SliceQuery>(serializer.getQuery(returnType, this.querySystem), (this.dir == Direction.BOTH || returnType == RelationCategory.PROPERTY && this.dir == Direction.OUT) && !conditions.hasChildren(), this.orders.isEmpty(), null);
            if (sliceLimit != Integer.MAX_VALUE && sliceLimit < 0x2AAAAAAA && this.dir != Direction.BOTH && (returnType == RelationCategory.EDGE || returnType == RelationCategory.RELATION)) {
                sliceLimit *= 2;
            }
            query.getBackendQuery().setLimit(this.computeLimit(conditions.size(), sliceLimit));
            queries = ImmutableList.of(query);
            conditions.add(returnType);
            conditions.add(new VisibilityFilterCondition(this.querySystem ? VisibilityFilterCondition.Visibility.SYSTEM : VisibilityFilterCondition.Visibility.NORMAL));
        } else {
            HashSet<RelationType> ts = new HashSet<RelationType>(this.types.length);
            queries = new ArrayList(this.types.length + 2);
            HashMap<RelationType, Interval> intervalConstraints = new HashMap<RelationType, Interval>(conditions.size());
            boolean isIntervalFittedConditions = this.compileConstraints(conditions, intervalConstraints);
            for (Interval pint : intervalConstraints.values()) {
                if (!pint.isEmpty()) continue;
                return BaseVertexCentricQuery.emptyQuery();
            }
            for (String typeName : this.types) {
                InternalRelationType type = QueryUtil.getType(this.tx, typeName);
                if (type == null) continue;
                Preconditions.checkArgument((!this.querySystem || type instanceof SystemRelationType ? 1 : 0) != 0, (String)"Can only query for system types: %s", (Object[])new Object[]{type});
                if (type instanceof ImplicitKey) {
                    throw new UnsupportedOperationException("Implicit types are not supported in complex queries: " + type);
                }
                ts.add(type);
                Direction typeDir = this.dir;
                if (type.isPropertyKey()) {
                    if (returnType == RelationCategory.EDGE) {
                        throw new IllegalArgumentException("Querying for edges but including a property key: " + type.getName());
                    }
                    returnType = RelationCategory.PROPERTY;
                    typeDir = Direction.OUT;
                }
                if (type.isEdgeLabel()) {
                    if (returnType == RelationCategory.PROPERTY) {
                        throw new IllegalArgumentException("Querying for properties but including an edge label: " + type.getName());
                    }
                    returnType = RelationCategory.EDGE;
                    if (!type.isUnidirected(Direction.BOTH)) {
                        if (typeDir == Direction.BOTH) {
                            typeDir = type.isUnidirected(Direction.OUT) ? Direction.OUT : Direction.IN;
                        } else if (!type.isUnidirected(typeDir)) continue;
                    }
                }
                if (type.isEdgeLabel() && typeDir == Direction.BOTH && intervalConstraints.isEmpty() && this.orders.isEmpty()) {
                    SliceQuery q = serializer.getQuery(type, typeDir, null);
                    q.setLimit(sliceLimit);
                    queries.add(new BackendQueryHolder<SliceQuery>(q, isIntervalFittedConditions, true, null));
                    continue;
                }
                Direction[] dirs = new Direction[]{typeDir};
                if (typeDir == Direction.BOTH) {
                    dirs = type.isEdgeLabel() ? new Direction[]{Direction.OUT, Direction.IN} : new Direction[]{Direction.OUT};
                }
                for (Direction direction : dirs) {
                    InternalRelationType bestCandidate = null;
                    double bestScore = Double.NEGATIVE_INFINITY;
                    boolean bestCandidateSupportsOrder = false;
                    for (InternalRelationType candidate : type.getRelationIndexes()) {
                        if (!candidate.isUnidirected(Direction.BOTH) && !candidate.isUnidirected(direction) || candidate.getStatus() != SchemaStatus.ENABLED) continue;
                        boolean supportsOrder = this.orders.isEmpty() ? true : this.orders.getCommonOrder() == candidate.getSortOrder();
                        int currentOrder = 0;
                        double score = 0.0;
                        RelationType[] extendedSortKey = BasicVertexCentricQueryBuilder.getExtendedSortKey(candidate, direction, this.tx);
                        for (int i = 0; i < extendedSortKey.length; ++i) {
                            Interval interval;
                            RelationType keyType = extendedSortKey[i];
                            if (currentOrder < this.orders.size() && this.orders.getKey(currentOrder).equals(keyType)) {
                                ++currentOrder;
                            }
                            if ((interval = (Interval)intervalConstraints.get(keyType)) == null || !interval.isPoints()) {
                                if (interval == null) break;
                                score += 1.0;
                                break;
                            }
                            assert (interval.isPoints());
                            score += 5.0 / (double)interval.getPoints().size();
                        }
                        if (supportsOrder && currentOrder == this.orders.size()) {
                            score += 3.0;
                        }
                        if (!(score > bestScore)) continue;
                        bestScore = score;
                        bestCandidate = candidate;
                        bestCandidateSupportsOrder = supportsOrder && currentOrder == this.orders.size();
                    }
                    Preconditions.checkArgument((bestCandidate != null ? 1 : 0) != 0, (String)"Current graph schema does not support the specified query constraints for type: %s", (Object[])new Object[]{type.getName()});
                    RelationType[] extendedSortKey = BasicVertexCentricQueryBuilder.getExtendedSortKey(bestCandidate, direction, this.tx);
                    EdgeSerializer.TypedInterval[] sortKeyConstraints = new EdgeSerializer.TypedInterval[extendedSortKey.length];
                    this.constructSliceQueries(extendedSortKey, sortKeyConstraints, 0, bestCandidate, direction, intervalConstraints, sliceLimit, isIntervalFittedConditions, bestCandidateSupportsOrder, (List<BackendQueryHolder<SliceQuery>>)queries);
                }
            }
            if (queries.isEmpty()) {
                return BaseVertexCentricQuery.emptyQuery();
            }
            conditions.add(BasicVertexCentricQueryBuilder.getTypeCondition(ts));
        }
        return new BaseVertexCentricQuery(QueryUtil.simplifyQNF(conditions), this.dir, (List<BackendQueryHolder<SliceQuery>>)queries, this.orders, this.limit);
    }

    private void constructSliceQueries(RelationType[] extendedSortKey, EdgeSerializer.TypedInterval[] sortKeyConstraints, int position, InternalRelationType bestCandidate, Direction direction, Map<RelationType, Interval> intervalConstraints, int sliceLimit, boolean isIntervalFittedConditions, boolean bestCandidateSupportsOrder, List<BackendQueryHolder<SliceQuery>> queries) {
        boolean isFitted;
        if (position < extendedSortKey.length) {
            RelationType keyType = extendedSortKey[position];
            Interval interval = intervalConstraints.get(keyType);
            if (interval != null) {
                sortKeyConstraints[position] = new EdgeSerializer.TypedInterval((InternalRelationType)keyType, interval);
                ++position;
            }
            if (interval != null && interval.isPoints()) {
                for (Object point : interval.getPoints()) {
                    EdgeSerializer.TypedInterval[] clonedSKC = Arrays.copyOf(sortKeyConstraints, sortKeyConstraints.length);
                    clonedSKC[position - 1] = new EdgeSerializer.TypedInterval((InternalRelationType)keyType, new PointInterval(point));
                    this.constructSliceQueries(extendedSortKey, clonedSKC, position, bestCandidate, direction, intervalConstraints, sliceLimit, isIntervalFittedConditions, bestCandidateSupportsOrder, queries);
                }
                return;
            }
        }
        boolean bl = isFitted = isIntervalFittedConditions && position == intervalConstraints.size();
        if (isFitted && position > 0) {
            EdgeSerializer.TypedInterval lastInterval = sortKeyConstraints[position - 1];
            if (!lastInterval.interval.isPoints() && lastInterval.interval.getEnd() == null) {
                isFitted = false;
            }
        }
        EdgeSerializer serializer = this.tx.getEdgeSerializer();
        SliceQuery q = serializer.getQuery(bestCandidate, direction, sortKeyConstraints);
        q.setLimit(this.computeLimit(intervalConstraints.size() - position, sliceLimit));
        queries.add(new BackendQueryHolder<SliceQuery>(q, isFitted, bestCandidateSupportsOrder, null));
    }

    private static RelationType[] getExtendedSortKey(InternalRelationType type, Direction dir, StandardTitanTx tx) {
        int additional = 0;
        if (!type.getMultiplicity().isUnique(dir)) {
            if (!type.getMultiplicity().isConstrained()) {
                ++additional;
            }
            if (type.isEdgeLabel()) {
                ++additional;
            }
        }
        RelationType[] entireKey = new RelationType[type.getSortKey().length + additional];
        for (int i = 0; i < type.getSortKey().length; ++i) {
            entireKey[i] = tx.getExistingRelationType(type.getSortKey()[i]);
        }
        if (type.isEdgeLabel() && !type.getMultiplicity().isUnique(dir)) {
            entireKey[i++] = ImplicitKey.ADJACENT_ID;
        }
        if (!type.getMultiplicity().isConstrained()) {
            entireKey[i++] = ImplicitKey.TITANID;
        }
        return entireKey;
    }

    private boolean compileConstraints(And<TitanRelation> conditions, Map<RelationType, Interval> constraintMap) {
        boolean isFitted = true;
        for (Condition condition : conditions.getChildren()) {
            RelationType type = null;
            Interval newInterval = null;
            if (condition instanceof Or) {
                Map.Entry<RelationType, Collection> orEqual = QueryUtil.extractOrCondition((Or)condition);
                if (orEqual != null) {
                    type = orEqual.getKey();
                    newInterval = new PointInterval(orEqual.getValue());
                }
            } else if (condition instanceof PredicateCondition) {
                PredicateCondition atom = (PredicateCondition)condition;
                type = (RelationType)atom.getKey();
                Interval interval = constraintMap.get(type);
                newInterval = BasicVertexCentricQueryBuilder.intersectConstraints(interval, type, atom.getPredicate(), atom.getValue());
            }
            if (newInterval != null) {
                constraintMap.put(type, newInterval);
                continue;
            }
            isFitted = false;
        }
        if (this.adjacentVertex != null) {
            if (this.adjacentVertex.hasId()) {
                constraintMap.put(ImplicitKey.ADJACENT_ID, new PointInterval<Long>(this.adjacentVertex.getLongId()));
            } else {
                isFitted = false;
            }
        }
        return isFitted;
    }

    private static Interval intersectConstraints(Interval pint, RelationType type, TitanPredicate predicate, Object value) {
        Interval<Object> newInt;
        block11: {
            block10: {
                if (!(predicate instanceof Cmp)) break block10;
                switch ((Cmp)predicate) {
                    case EQUAL: {
                        if (value == null) {
                            return null;
                        }
                        newInt = new PointInterval<Object>(value);
                        break block11;
                    }
                    case NOT_EQUAL: {
                        return null;
                    }
                    case LESS_THAN: {
                        newInt = new RangeInterval<Object>().setEnd(value, false);
                        break block11;
                    }
                    case LESS_THAN_EQUAL: {
                        newInt = new RangeInterval<Object>().setEnd(value, true);
                        break block11;
                    }
                    case GREATER_THAN: {
                        newInt = new RangeInterval<Object>().setStart(value, false);
                        break block11;
                    }
                    case GREATER_THAN_EQUAL: {
                        newInt = new RangeInterval<Object>().setStart(value, true);
                        break block11;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            return null;
        }
        assert (newInt != null);
        return pint != null ? pint.intersect(newInt) : newInt;
    }

    private static Condition<TitanRelation> getTypeCondition(Set<RelationType> types) {
        assert (!types.isEmpty());
        if (types.size() == 1) {
            return new RelationTypeCondition<TitanRelation>(types.iterator().next());
        }
        Or<TitanRelation> typeCond = new Or<TitanRelation>(types.size());
        for (RelationType type : types) {
            typeCond.add(new RelationTypeCondition(type));
        }
        return typeCond;
    }

    private int computeLimit(int remainingConditions, int baseLimit) {
        if (baseLimit == Integer.MAX_VALUE) {
            return baseLimit;
        }
        assert (baseLimit > 0);
        baseLimit = Math.max(baseLimit, Math.min(300000, QueryUtil.adjustLimitForTxModifications(this.tx, remainingConditions, baseLimit)));
        assert (baseLimit > 0);
        return baseLimit;
    }

    protected class VertexIdConstructor
    implements ResultConstructor<VertexList> {
        protected VertexIdConstructor() {
        }

        @Override
        public VertexList getResult(InternalVertex v, BaseVertexCentricQuery bq) {
            return BasicVertexCentricQueryBuilder.this.executeVertexIds(v, bq);
        }

        @Override
        public VertexList emptyResult() {
            return new VertexArrayList(BasicVertexCentricQueryBuilder.this.tx);
        }
    }

    protected class VertexConstructor
    implements ResultConstructor<Iterable<TitanVertex>> {
        protected VertexConstructor() {
        }

        @Override
        public Iterable<TitanVertex> getResult(InternalVertex v, BaseVertexCentricQuery bq) {
            return BasicVertexCentricQueryBuilder.this.executeVertices(v, bq);
        }

        @Override
        public Iterable<TitanVertex> emptyResult() {
            return Collections.EMPTY_LIST;
        }
    }

    protected class RelationConstructor
    implements ResultConstructor<Iterable<? extends TitanRelation>> {
        protected RelationConstructor() {
        }

        @Override
        public Iterable<? extends TitanRelation> getResult(InternalVertex v, BaseVertexCentricQuery bq) {
            return BasicVertexCentricQueryBuilder.this.executeRelations(v, bq);
        }

        @Override
        public Iterable<? extends TitanRelation> emptyResult() {
            return Collections.EMPTY_LIST;
        }
    }

    protected static interface ResultConstructor<Q> {
        public Q getResult(InternalVertex var1, BaseVertexCentricQuery var2);

        public Q emptyResult();
    }
}

