/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.accumulo.core.iterators.conf.ColumnToClassMapping;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.log4j.Logger;

@Deprecated
public class AggregatingIterator
implements SortedKeyValueIterator<Key, Value>,
OptionDescriber {
    private SortedKeyValueIterator<Key, Value> iterator;
    private ColumnToClassMapping<Aggregator> aggregators;
    private Key workKey = new Key();
    private Key aggrKey;
    private Value aggrValue;
    private static final Logger log = Logger.getLogger(AggregatingIterator.class);

    public AggregatingIterator deepCopy(IteratorEnvironment env) {
        return new AggregatingIterator(this, env);
    }

    private AggregatingIterator(AggregatingIterator other, IteratorEnvironment env) {
        this.iterator = other.iterator.deepCopy(env);
        this.aggregators = other.aggregators;
    }

    public AggregatingIterator() {
    }

    private void aggregateRowColumn(Aggregator aggr) throws IOException {
        if (this.iterator.getTopKey().isDeleted()) {
            return;
        }
        this.workKey.set(this.iterator.getTopKey());
        Key keyToAggregate = this.workKey;
        aggr.reset();
        aggr.collect(this.iterator.getTopValue());
        this.iterator.next();
        while (this.iterator.hasTop() && !this.iterator.getTopKey().isDeleted() && this.iterator.getTopKey().equals(keyToAggregate, PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            aggr.collect(this.iterator.getTopValue());
            this.iterator.next();
        }
        this.aggrKey = this.workKey;
        this.aggrValue = aggr.aggregate();
    }

    private void findTop() throws IOException {
        Aggregator aggr;
        if (this.iterator.hasTop() && (aggr = this.aggregators.getObject(this.iterator.getTopKey())) != null) {
            this.aggregateRowColumn(aggr);
        }
    }

    public AggregatingIterator(SortedKeyValueIterator<Key, Value> iterator, ColumnToClassMapping<Aggregator> aggregators) throws IOException {
        this.iterator = iterator;
        this.aggregators = aggregators;
    }

    @Override
    public Key getTopKey() {
        if (this.aggrKey != null) {
            return this.aggrKey;
        }
        return this.iterator.getTopKey();
    }

    @Override
    public Value getTopValue() {
        if (this.aggrKey != null) {
            return this.aggrValue;
        }
        return this.iterator.getTopValue();
    }

    @Override
    public boolean hasTop() {
        return this.aggrKey != null || this.iterator.hasTop();
    }

    @Override
    public void next() throws IOException {
        if (this.aggrKey != null) {
            this.aggrKey = null;
            this.aggrValue = null;
        } else {
            this.iterator.next();
        }
        this.findTop();
    }

    @Override
    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Range seekRange = IteratorUtil.maximizeStartKeyTimeStamp(range);
        this.iterator.seek(seekRange, columnFamilies, inclusive);
        this.findTop();
        if (range.getStartKey() != null) {
            while (this.hasTop() && this.getTopKey().equals(range.getStartKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS) && this.getTopKey().getTimestamp() > range.getStartKey().getTimestamp()) {
                this.next();
            }
            while (this.hasTop() && range.beforeStartKey(this.getTopKey())) {
                this.next();
            }
        }
    }

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.iterator = source;
        try {
            String context = null;
            if (null != env) {
                context = env.getConfig().get(Property.TABLE_CLASSPATH);
            }
            this.aggregators = new ColumnToClassMapping<Aggregator>(options, Aggregator.class, context);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.toString());
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.toString());
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        return new OptionDescriber.IteratorOptions("agg", "Aggregators apply aggregating functions to values with identical keys", null, Collections.singletonList("<columnName> <aggregatorClass>"));
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String classname = entry.getValue();
            if (classname == null) {
                throw new IllegalArgumentException("classname null");
            }
            try {
                Class clazz = AccumuloVFSClassLoader.loadClass((String)classname, Aggregator.class);
                clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("class not found: " + classname);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("instantiation exception: " + classname);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("illegal access exception: " + classname);
            }
        }
        return true;
    }
}

