/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool.impl;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.connectionpool.HostConnectionPool;
import com.netflix.astyanax.connectionpool.LatencyScoreStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class HostConnectionPoolPartition<CL> {
    protected final AtomicBoolean prioritize = new AtomicBoolean(false);
    protected final NonBlockingHashSet<HostConnectionPool<CL>> pools = new NonBlockingHashSet();
    protected final AtomicReference<List<HostConnectionPool<CL>>> activePools = new AtomicReference();
    protected final LatencyScoreStrategy strategy;

    public HostConnectionPoolPartition(LatencyScoreStrategy strategy) {
        this.strategy = strategy;
        this.activePools.set(Lists.newArrayList());
    }

    public synchronized boolean setPools(Collection<HostConnectionPool<CL>> newPools) {
        HashSet toRemove = Sets.newHashSet(this.pools);
        boolean didChange = false;
        for (HostConnectionPool<Object> pool : newPools) {
            if (this.pools.add(pool)) {
                didChange = true;
            }
            toRemove.remove(pool);
        }
        for (HostConnectionPool<Object> pool : toRemove) {
            if (!this.pools.remove(pool)) continue;
            didChange = true;
        }
        if (didChange) {
            this.refresh();
        }
        return didChange;
    }

    public synchronized boolean addPool(HostConnectionPool<CL> pool) {
        if (this.pools.add(pool)) {
            this.refresh();
            return true;
        }
        return false;
    }

    public synchronized boolean removePool(HostConnectionPool<CL> pool) {
        if (this.pools.remove(pool)) {
            this.refresh();
            return true;
        }
        return false;
    }

    public List<HostConnectionPool<CL>> getPools() {
        return this.activePools.get();
    }

    public boolean isSorted() {
        return this.prioritize.get();
    }

    public boolean hasPool(HostConnectionPool<CL> pool) {
        return this.pools.contains(pool);
    }

    public synchronized void refresh() {
        ArrayList pools = Lists.newArrayList();
        for (HostConnectionPool pool : this.pools) {
            if (pool.isReconnecting()) continue;
            pools.add(pool);
        }
        this.activePools.set(this.strategy.sortAndfilterPartition(pools, this.prioritize));
    }

    public String toString() {
        return "BaseHostConnectionPoolPartition[" + StringUtils.join((Collection)Collections2.transform(this.getPools(), (Function)new Function<HostConnectionPool<CL>, String>(){

            public String apply(HostConnectionPool<CL> host) {
                return host.getHost().getHostName();
            }
        }), (String)",") + "]";
    }
}

