/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.groovy.jsr223;

import com.tinkerpop.gremlin.groovy.Gremlin;
import com.tinkerpop.gremlin.groovy.jsr223.DefaultImportCustomizerProvider;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import com.tinkerpop.gremlin.groovy.jsr223.ImportCustomizerProvider;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.DelegatingMetaClass;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.lang.Tuple;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.jsr223.GroovyCompiledScript;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.syntax.SyntaxException;

public class GremlinGroovyScriptEngine
extends GroovyScriptEngineImpl {
    private Map<String, Class> classMap = new ConcurrentHashMap<String, Class>();
    private Map<String, MethodClosure> globalClosures = new ConcurrentHashMap<String, MethodClosure>();
    protected GroovyClassLoader loader;
    private volatile GremlinGroovyScriptEngineFactory factory;
    private static int counter = 0;
    private int cacheResetSize = 1500;
    private static final String SCRIPT = "Script";
    private static final String DOT_GROOVY = ".groovy";
    private static final String GROOVY_LANG_SCRIPT = "groovy.lang.Script";

    public GremlinGroovyScriptEngine() {
        this(new DefaultImportCustomizerProvider());
    }

    public GremlinGroovyScriptEngine(int cacheResetSize) {
        this();
        this.cacheResetSize = cacheResetSize;
    }

    public GremlinGroovyScriptEngine(ImportCustomizerProvider importCustomizerProvider) {
        Gremlin.load();
        CompilerConfiguration conf = new CompilerConfiguration();
        conf.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizerProvider.getImportCustomizer()});
        this.loader = new GroovyClassLoader(this.getParentLoader(), conf);
    }

    private void checkClearCache() {
        if (this.classMap.size() > this.cacheResetSize) {
            this.globalClosures.clear();
            this.classMap.clear();
            this.loader.clearCache();
        }
    }

    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readFully(reader), context);
    }

    public Object eval(String script, ScriptContext context) throws ScriptException {
        try {
            return this.eval(this.getScriptClass(script), context);
        }
        catch (SyntaxException e) {
            throw new ScriptException(e.getMessage(), e.getSourceLocator(), e.getLine());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    public Bindings createBindings() {
        return new SimpleBindings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptEngineFactory getFactory() {
        if (this.factory == null) {
            GremlinGroovyScriptEngine gremlinGroovyScriptEngine = this;
            synchronized (gremlinGroovyScriptEngine) {
                if (this.factory == null) {
                    this.factory = new GremlinGroovyScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    public CompiledScript compile(String scriptSource) throws ScriptException {
        try {
            return new GroovyCompiledScript((GroovyScriptEngineImpl)this, this.getScriptClass(scriptSource));
        }
        catch (SyntaxException e) {
            throw new ScriptException(e.getMessage(), e.getSourceLocator(), e.getLine());
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (CompilationFailedException ee) {
            throw new ScriptException((Exception)((Object)ee));
        }
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.compile(this.readFully(reader));
    }

    public Object invokeFunction(String name, Object[] args) throws ScriptException, NoSuchMethodException {
        return this.invokeImpl(null, name, args);
    }

    public Object invokeMethod(Object thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        if (thiz == null) {
            throw new IllegalArgumentException("Script object can not be null");
        }
        return this.invokeImpl(thiz, name, args);
    }

    public Object getInterface(Class clasz) {
        return this.makeInterface(null, clasz);
    }

    public Object getInterface(Object thiz, Class clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("Script object can not be null");
        }
        return this.makeInterface(thiz, clasz);
    }

    Object eval(Class scriptClass, final ScriptContext context) throws ScriptException {
        this.checkClearCache();
        context.setAttribute("context", context, 100);
        Writer writer = context.getWriter();
        context.setAttribute("out", writer instanceof PrintWriter ? writer : new PrintWriter(writer), 100);
        Binding binding = new Binding(){

            public Object getVariable(String name) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    int scope = context.getAttributesScope(name);
                    if (scope != -1) {
                        return context.getAttribute(name, scope);
                    }
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setVariable(String name, Object value) {
                ScriptContext scriptContext = context;
                synchronized (scriptContext) {
                    int scope = context.getAttributesScope(name);
                    if (scope == -1) {
                        scope = 100;
                    }
                    context.setAttribute(name, value, scope);
                }
            }
        };
        try {
            Script scriptObject = InvokerHelper.createScript((Class)scriptClass, (Binding)binding);
            Method[] methods = scriptClass.getMethods();
            HashMap<String, MethodClosure> closures = new HashMap<String, MethodClosure>();
            for (Method m : methods) {
                String name = m.getName();
                closures.put(name, new MethodClosure((Object)scriptObject, name));
            }
            this.globalClosures.putAll(closures);
            MetaClass oldMetaClass = scriptObject.getMetaClass();
            scriptObject.setMetaClass((MetaClass)new DelegatingMetaClass(oldMetaClass){

                public Object invokeMethod(Object object, String name, Object args) {
                    if (args == null) {
                        return this.invokeMethod(object, name, MetaClassHelper.EMPTY_ARRAY);
                    }
                    if (args instanceof Tuple) {
                        return this.invokeMethod(object, name, ((Tuple)args).toArray());
                    }
                    if (args instanceof Object[]) {
                        return this.invokeMethod(object, name, (Object[])args);
                    }
                    return this.invokeMethod(object, name, new Object[]{args});
                }

                public Object invokeMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }

                public Object invokeStaticMethod(Object object, String name, Object[] args) {
                    try {
                        return super.invokeStaticMethod(object, name, args);
                    }
                    catch (MissingMethodException mme) {
                        return GremlinGroovyScriptEngine.this.callGlobal(name, args, context);
                    }
                }
            });
            return scriptObject.run();
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
    }

    Class getScriptClass(String script) throws SyntaxException, CompilationFailedException, IOException {
        Class clazz = this.classMap.get(script);
        if (clazz != null) {
            return clazz;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(script.getBytes());
        clazz = this.loader.parseClass((InputStream)stream, this.generateScriptName());
        this.classMap.put(script, clazz);
        return clazz;
    }

    private Object invokeImpl(Object thiz, String name, Object[] args) throws ScriptException, NoSuchMethodException {
        if (name == null) {
            throw new NullPointerException("Method name can not be null");
        }
        try {
            if (thiz != null) {
                return InvokerHelper.invokeMethod((Object)thiz, (String)name, (Object)args);
            }
        }
        catch (MissingMethodException mme) {
            throw new NoSuchMethodException(mme.getMessage());
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        return this.callGlobal(name, args);
    }

    private Object callGlobal(String name, Object[] args) {
        return this.callGlobal(name, args, this.context);
    }

    private Object callGlobal(String name, Object[] args, ScriptContext ctx) {
        Closure closure = (Closure)this.globalClosures.get(name);
        if (closure != null) {
            return closure.call(args);
        }
        Object value = ctx.getAttribute(name);
        if (value instanceof Closure) {
            return ((Closure)value).call(args);
        }
        throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
    }

    private synchronized String generateScriptName() {
        return SCRIPT + ++counter + DOT_GROOVY;
    }

    private Object makeInterface(final Object obj, Class clazz) {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
                return GremlinGroovyScriptEngine.this.invokeImpl(obj, m.getName(), args);
            }
        });
    }

    protected ClassLoader getParentLoader() {
        ClassLoader ctxtLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> c = ctxtLoader.loadClass(GROOVY_LANG_SCRIPT);
            if (c == Script.class) {
                return ctxtLoader;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Script.class.getClassLoader();
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }
}

