/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mrunit.TestDriver;
import org.apache.hadoop.mrunit.internal.io.Serialization;
import org.apache.hadoop.mrunit.internal.output.MockOutputCreator;
import org.apache.hadoop.mrunit.types.Pair;

public abstract class ReduceDriverBase<K1, V1, K2, V2, T extends ReduceDriverBase<K1, V1, K2, V2, T>>
extends TestDriver<K2, V2, T> {
    protected List<Pair<K1, List<V1>>> inputs = new ArrayList<Pair<K1, List<V1>>>();
    @Deprecated
    protected K1 inputKey;
    @Deprecated
    private final List<V1> inputValues;
    protected final MockOutputCreator<K2, V2> mockOutputCreator = new MockOutputCreator();

    public ReduceDriverBase() {
        this.inputValues = new ArrayList<V1>();
    }

    @Deprecated
    public List<V1> getInputValues() {
        return this.inputValues;
    }

    public List<V1> getInputValues(K1 key) {
        for (Pair<K1, List<V1>> p : this.inputs) {
            if (!p.getFirst().equals(key)) continue;
            return p.getSecond();
        }
        return null;
    }

    @Deprecated
    public void setInputKey(K1 key) {
        this.inputKey = this.copy(key);
    }

    @Deprecated
    public void addInputValue(V1 val) {
        this.inputValues.add(this.copy(val));
    }

    @Deprecated
    public void setInputValues(List<V1> values) {
        this.inputValues.clear();
        this.addInputValues(values);
    }

    @Deprecated
    public void addInputValues(List<V1> values) {
        for (V1 value : values) {
            this.addInputValue(value);
        }
    }

    public void setInput(K1 key, List<V1> values) {
        this.setInputKey(key);
        this.setInputValues(values);
        this.clearInput();
        this.addInput(key, values);
    }

    public void clearInput() {
        this.inputs.clear();
    }

    public void addInput(K1 key, List<V1> values) {
        ArrayList<V1> copyVals = new ArrayList<V1>();
        for (V1 val : values) {
            copyVals.add(this.copy(val));
        }
        this.inputs.add(new Pair(this.copy(key), new ValueClassInstanceReuseList(copyVals, this.getConfiguration())));
    }

    public void addInput(Pair<K1, List<V1>> input) {
        this.addInput(input.getFirst(), input.getSecond());
    }

    public void addAll(List<Pair<K1, List<V1>>> inputs) {
        for (Pair<K1, List<V1>> input : inputs) {
            this.addInput(input);
        }
    }

    @Deprecated
    public void setInputFromString(String input) {
        Pair<Text, Text> inputPair = ReduceDriverBase.parseTabbedPair(input);
        this.setInputKey(inputPair.getFirst());
        this.setInputValues(ReduceDriverBase.parseCommaDelimitedList(inputPair.getSecond().toString()));
    }

    private T thisAsReduceDriver() {
        return (T)this;
    }

    @Deprecated
    public T withInputKey(K1 key) {
        this.setInputKey(key);
        return this.thisAsReduceDriver();
    }

    @Deprecated
    public T withInputValue(V1 val) {
        this.addInputValue(val);
        return this.thisAsReduceDriver();
    }

    @Deprecated
    public T withInputValues(List<V1> values) {
        this.addInputValues(values);
        return this.thisAsReduceDriver();
    }

    public T withInput(K1 key, List<V1> values) {
        this.addInput(key, values);
        return this.thisAsReduceDriver();
    }

    @Deprecated
    public T withInputFromString(String input) {
        this.setInputFromString(input);
        return this.thisAsReduceDriver();
    }

    public T withInput(Pair<K1, List<V1>> input) {
        this.addInput(input);
        return this.thisAsReduceDriver();
    }

    public T withAll(List<Pair<K1, List<V1>>> inputs) {
        this.addAll(inputs);
        return this.thisAsReduceDriver();
    }

    protected void preRunChecks(Object reducer) {
        if (this.inputKey != null && !this.getInputValues().isEmpty()) {
            this.clearInput();
            this.addInput(this.inputKey, this.getInputValues());
        }
        if (this.inputs == null || this.inputs.isEmpty()) {
            throw new IllegalStateException("No input was provided");
        }
        if (reducer == null) {
            throw new IllegalStateException("No Reducer class was provided");
        }
        if (this.driverReused()) {
            throw new IllegalStateException("Driver reuse not allowed");
        }
        this.setUsedOnceStatus();
    }

    @Override
    public abstract List<Pair<K2, V2>> run() throws IOException;

    @Override
    protected void printPreTestDebugLog() {
        StringBuilder sb = new StringBuilder();
        for (Pair<K1, List<V1>> input : this.inputs) {
            ReduceDriverBase.formatValueList(input.getSecond(), sb);
            LOG.debug((Object)("Reducing input (" + input.getFirst() + ", " + sb + ")"));
            sb.delete(0, sb.length());
        }
    }

    protected static class ValueClassInstanceReuseList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 1L;
        private T value;
        private final Serialization serialization;

        public ValueClassInstanceReuseList(List<T> list, Configuration conf) {
            super(list);
            this.serialization = new Serialization(conf);
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator listIterator = super.iterator();
            final T currentValue = this.value;
            return new Iterator<T>(){
                private T value;
                private final Iterator<T> iterator;
                {
                    this.value = currentValue;
                    this.iterator = listIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public T next() {
                    Object next = this.iterator.next();
                    this.value = ValueClassInstanceReuseList.this.serialization.copy(next, this.value);
                    return this.value;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

