/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mrunit.ReduceDriverBase;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.mapreduce.ContextDriver;
import org.apache.hadoop.mrunit.internal.mapreduce.MockReduceContextWrapper;
import org.apache.hadoop.mrunit.internal.output.MockMultipleOutputs;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.mapreduce.ReduceFeeder;
import org.apache.hadoop.mrunit.types.KeyValueReuseList;
import org.apache.hadoop.mrunit.types.Pair;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={MultipleOutputs.class})
public class ReduceDriver<K1, V1, K2, V2>
extends ReduceDriverBase<K1, V1, K2, V2, ReduceDriver<K1, V1, K2, V2>>
implements ContextDriver {
    protected List<KeyValueReuseList<K1, V1>> groupedInputs = new ArrayList<KeyValueReuseList<K1, V1>>();
    public static final Log LOG = LogFactory.getLog(ReduceDriver.class);
    protected Reducer<K1, V1, K2, V2> myReducer;
    private Counters counters;
    private MockReduceContextWrapper<K1, V1, K2, V2> wrapper;

    public List<Pair<K1, V1>> getInputs(K1 firstKey) {
        for (KeyValueReuseList<K1, V1> p : this.groupedInputs) {
            if (!p.getCurrentKey().equals(firstKey)) continue;
            return p;
        }
        return null;
    }

    @Override
    public void clearInput() {
        super.clearInput();
        this.groupedInputs.clear();
    }

    @Override
    public void addInput(KeyValueReuseList<K1, V1> input) {
        this.groupedInputs.add(input.clone(this.getConfiguration()));
    }

    @Override
    public ReduceDriver<K1, V1, K2, V2> withInput(KeyValueReuseList<K1, V1> input) {
        this.addInput(input);
        return this;
    }

    public ReduceDriver<K1, V1, K2, V2> withAllElements(List<KeyValueReuseList<K1, V1>> inputs) {
        this.addAllElements(inputs);
        return this;
    }

    public void addAllElements(List<KeyValueReuseList<K1, V1>> inputs) {
        for (KeyValueReuseList<K1, V1> input : inputs) {
            this.addInput(input);
        }
    }

    @Override
    protected void printPreTestDebugLog() {
        StringBuilder sb = new StringBuilder();
        for (List list : this.groupedInputs) {
            ReduceDriver.formatPairList(list, sb);
            LOG.debug((Object)("Reducing input " + sb));
            sb.delete(0, sb.length());
        }
    }

    public ReduceDriver(Reducer<K1, V1, K2, V2> r) {
        this();
        this.setReducer(r);
    }

    public ReduceDriver() {
        this.setCounters(new Counters());
    }

    public void setReducer(Reducer<K1, V1, K2, V2> r) {
        this.myReducer = ArgumentChecker.returnNonNull(r);
    }

    public ReduceDriver<K1, V1, K2, V2> withReducer(Reducer<K1, V1, K2, V2> r) {
        this.setReducer(r);
        return this;
    }

    public Reducer<K1, V1, K2, V2> getReducer() {
        return this.myReducer;
    }

    @Override
    public Counters getCounters() {
        return this.counters;
    }

    public void setCounters(Counters ctrs) {
        this.counters = ctrs;
        this.counterWrapper = new CounterWrapper(ctrs);
    }

    public ReduceDriver<K1, V1, K2, V2> withCounters(Counters ctrs) {
        this.setCounters(ctrs);
        return this;
    }

    public ReduceDriver<K1, V1, K2, V2> withOutputFormat(Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass) {
        this.mockOutputCreator.setMapreduceFormats(outputFormatClass, inputFormatClass);
        return this;
    }

    @Override
    protected void preRunChecks(Object reducer) {
        if (this.inputKey != null && !this.getInputValues().isEmpty()) {
            this.clearInput();
            this.addInput(new ReduceFeeder(this.getConfiguration()).updateInput(this.inputKey, this.getInputValues()));
        }
        if (this.inputs != null && !this.inputs.isEmpty()) {
            this.groupedInputs.clear();
            this.groupedInputs = new ReduceFeeder(this.getConfiguration()).updateAll(this.inputs);
        }
        if (this.groupedInputs == null || this.groupedInputs.isEmpty()) {
            throw new IllegalStateException("No input was provided");
        }
        if (reducer == null) {
            throw new IllegalStateException("No Reducer class was provided");
        }
        if (this.driverReused()) {
            throw new IllegalStateException("Driver reuse not allowed");
        }
        this.setUsedOnceStatus();
    }

    @Override
    public List<Pair<K2, V2>> run() throws IOException {
        try {
            this.preRunChecks(this.myReducer);
            this.initDistributedCache();
            MockReduceContextWrapper<K1, V1, K2, V2> wrapper = this.getContextWrapper();
            this.mos = new MockMultipleOutputs((TaskInputOutputContext)wrapper.getMockContext());
            try {
                PowerMockito.whenNew(MultipleOutputs.class).withArguments(wrapper.getMockContext(), new Object[0]).thenReturn((Object)this.mos);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            this.myReducer.run((Reducer.Context)wrapper.getMockContext());
            List list = wrapper.getOutputs();
            return list;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        finally {
            this.cleanupDistributedCache();
        }
    }

    public String toString() {
        return "ReduceDriver (0.20+) (" + this.myReducer + ")";
    }

    private MockReduceContextWrapper<K1, V1, K2, V2> getContextWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new MockReduceContextWrapper(this.getConfiguration(), this.groupedInputs, this.mockOutputCreator, this);
        }
        return this.wrapper;
    }

    public Reducer.Context getContext() {
        return (Reducer.Context)this.getContextWrapper().getMockContext();
    }

    public static <K1, V1, K2, V2> ReduceDriver<K1, V1, K2, V2> newReduceDriver() {
        return new ReduceDriver<K1, V1, K2, V2>();
    }

    public static <K1, V1, K2, V2> ReduceDriver<K1, V1, K2, V2> newReduceDriver(Reducer<K1, V1, K2, V2> reducer) {
        return new ReduceDriver<K1, V1, K2, V2>(reducer);
    }
}

