/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.serializer.kryo.quickSerializers;

import java.nio.charset.Charset;
import org.vertexium.serializer.kryo.quickSerializers.QuickTypeSerializer;

public class StringQuickTypeSerializer
implements QuickTypeSerializer {
    private Charset charset = Charset.forName("utf8");

    @Override
    public byte[] objectToBytes(Object value) {
        byte[] valueBytes = ((String)value).getBytes(this.charset);
        byte[] data = new byte[1 + valueBytes.length];
        data[0] = 1;
        System.arraycopy(valueBytes, 0, data, 1, valueBytes.length);
        return data;
    }

    @Override
    public <T> T valueToObject(byte[] data) {
        return (T)new String(data, 1, data.length - 1, this.charset);
    }
}

