/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DepthSearchAndSizeCounter {
    int bytes;
    int objectCount;
    int counter;
    HashMap<Integer, SeenEntry> seen = new HashMap();
    Set<SeenEntry> next = new HashSet<SeenEntry>();
    Set<SeenEntry> eleminate = new HashSet<SeenEntry>();
    boolean commonObjects = false;
    boolean circles = false;

    public void insert(Object o) {
        ++this.counter;
        this.nextLevel(null, o);
    }

    public int getNextCount() {
        return this.next.size();
    }

    public boolean hasNext() {
        return !this.next.isEmpty();
    }

    public void descend() throws EstimationException {
        SeenEntry e = null;
        try {
            Iterator<SeenEntry> it = this.next.iterator();
            this.next = new HashSet<SeenEntry>();
            this.eleminate = new HashSet<SeenEntry>();
            while (it.hasNext()) {
                e = it.next();
                this.descend(e);
            }
        }
        catch (Exception ex) {
            ArrayList _path = new ArrayList();
            while (e != null) {
                _path.add(0, e.object.getClass());
                e = e.via;
            }
            throw new EstimationException(ex, _path);
        }
        this.eleminateSeenEntries();
    }

    public void resetCounter() {
        this.objectCount = 0;
        this.bytes = 0;
        this.counter = 0;
    }

    void eleminateDescendantsFromNext(SeenEntry e) {
        this.next.remove(e);
        for (SeenEntry e2 : e.transitive) {
            this.eleminateDescendantsFromNext(e2);
        }
    }

    void eleminateSeenEntries() {
        for (SeenEntry e : this.eleminate) {
            this.eleminateDescendantsFromNext(e);
            this.bytes -= e.getTotalBytes();
            this.objectCount -= e.getObjectCount();
        }
    }

    void descend(SeenEntry e) throws IllegalAccessException {
        Object o = e.object;
        Class<?> c = o.getClass();
        if (c.isArray()) {
            this.recurseArray(e, c, o);
        } else {
            this.recurseFields(e, c, o);
        }
    }

    void recurseArray(SeenEntry e, Class<?> c, Object o) throws IllegalAccessException {
        Class<?> t = c.getComponentType();
        if (t.isPrimitive()) {
            e.bytes = t == Long.TYPE || t == Double.TYPE ? (e.bytes += 8 * Array.getLength(o)) : (e.bytes += 4 * Array.getLength(o));
        } else {
            Object[] oa = (Object[])o;
            e.bytes += 8 * Array.getLength(o);
            for (Object oi : oa) {
                this.nextLevel(e, oi);
            }
        }
        e.bytes += 24;
        this.bytes += e.bytes;
        ++this.objectCount;
    }

    void recurseFields(SeenEntry e, Class<?> c, Object o) throws IllegalAccessException {
        Field[] fa;
        if (c == null) {
            return;
        }
        this.recurseFields(e, c.getSuperclass(), o);
        for (Field f : fa = c.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            Class<?> t = f.getType();
            if (t.isPrimitive()) {
                if (t == Long.TYPE || t == Double.TYPE) {
                    e.bytes += 8;
                    continue;
                }
                e.bytes += 4;
                continue;
            }
            e.bytes += 8;
            f.setAccessible(true);
            Object o2 = f.get(o);
            this.nextLevel(e, o2);
        }
        e.bytes += 20;
        ++this.objectCount;
        this.bytes += e.bytes;
    }

    void nextLevel(SeenEntry _parent, Object o) {
        if (o == null) {
            return;
        }
        SeenEntry e = this.seen.get(System.identityHashCode(o));
        if (e != null) {
            if (_parent != null) {
                this.checkObjectNavigationPath(_parent, e);
            }
            ++e.referenceCount;
            if (!e.eleminated) {
                this.eleminate.add(e);
                e.eleminated = true;
            }
        } else {
            e = new SeenEntry(o);
            if (_parent != null) {
                _parent.transitive.add(e);
                e.via = _parent;
            }
            this.seen.put(System.identityHashCode(o), e);
            this.next.add(e);
        }
    }

    final void checkObjectNavigationPath(SeenEntry _parent, SeenEntry e) {
        if (!this.circles || !this.commonObjects) {
            SeenEntry r1;
            SeenEntry r0 = _parent.getRoot();
            if (r0 == (r1 = e.getRoot())) {
                this.circles = true;
            } else {
                this.commonObjects = true;
            }
        }
    }

    public int getByteCount() {
        return this.bytes;
    }

    public int getObjectCount() {
        return this.objectCount;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean hasCommonObjects() {
        return this.commonObjects;
    }

    public boolean hasCircles() {
        return this.circles;
    }

    public static class EstimationException
    extends Exception {
        List<Class<?>> path;

        EstimationException(Throwable cause, List<Class<?>> path) {
            super(cause);
            this.path = path;
        }

        public List<Class<?>> getPath() {
            return this.path;
        }
    }

    static class SeenEntry {
        SeenEntry via;
        Set<SeenEntry> transitive = new HashSet<SeenEntry>();
        Object object;
        int referenceCount = 1;
        int bytes;
        boolean eleminated;

        SeenEntry(Object object) {
            this.object = object;
        }

        public final SeenEntry getRoot() {
            return this.via == null ? this : this.via.getRoot();
        }

        public int getTotalBytes() {
            int v = this.bytes;
            for (SeenEntry e : this.transitive) {
                if (e.eleminated) continue;
                v += e.getTotalBytes();
            }
            return v;
        }

        public int getObjectCount() {
            int v = 1;
            for (SeenEntry e : this.transitive) {
                if (e.eleminated || e.bytes <= 0) continue;
                ++v;
                v += e.getObjectCount();
            }
            return v;
        }
    }
}

