/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.parser.sparql;

import info.aduna.text.StringUtil;

public class SPARQLUtil {
    public static String encodeString(String s) {
        s = StringUtil.gsub((String)"\\", (String)"\\\\", (String)s);
        s = StringUtil.gsub((String)"\t", (String)"\\t", (String)s);
        s = StringUtil.gsub((String)"\n", (String)"\\n", (String)s);
        s = StringUtil.gsub((String)"\r", (String)"\\r", (String)s);
        s = StringUtil.gsub((String)"\b", (String)"\\b", (String)s);
        s = StringUtil.gsub((String)"\f", (String)"\\f", (String)s);
        s = StringUtil.gsub((String)"\"", (String)"\\\"", (String)s);
        s = StringUtil.gsub((String)"'", (String)"\\'", (String)s);
        return s;
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'b') {
                sb.append('\b');
                startIdx = backSlashIdx + 2;
            } else if (c == 'f') {
                sb.append('\f');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\'') {
                sb.append('\'');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }
}

