/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class RetryingInvocationHandler
implements InvocationHandler {
    private final IZooReaderWriter zrw;
    private static final long INITIAL_RETRY_TIME = 250L;
    private static final long RETRY_INCREMENT = 250L;
    private static final long MAXIMUM_RETRY_TIME = 5000L;

    public RetryingInvocationHandler(IZooReaderWriter zrw) {
        this.zrw = zrw;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        long retryTime = 250L;
        while (true) {
            try {
                return method.invoke((Object)this.zrw, args);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof KeeperException.ConnectionLossException) {
                    Logger.getLogger(ZooReaderWriter.class).warn((Object)("Error connecting to zookeeper, will retry in " + String.format("%.2f secs", (double)retryTime / 1000.0)), e.getCause());
                    UtilWaitThread.sleep(retryTime);
                    retryTime = Math.min(5000L, retryTime + 250L);
                    continue;
                }
                throw e.getCause();
            }
            break;
        }
    }
}

