/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;

public class SnapshotShardFailure
implements ShardOperationFailedException {
    private String index;
    private int shardId;
    private String reason;
    @Nullable
    private String nodeId;
    private RestStatus status;

    private SnapshotShardFailure() {
    }

    public SnapshotShardFailure(@Nullable String nodeId, String index, int shardId, String reason) {
        this.nodeId = nodeId;
        this.index = index;
        this.shardId = shardId;
        this.reason = reason;
        this.status = RestStatus.INTERNAL_SERVER_ERROR;
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public int shardId() {
        return this.shardId;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Nullable
    public String nodeId() {
        return this.nodeId;
    }

    public static SnapshotShardFailure readSnapshotShardFailure(StreamInput in) throws IOException {
        SnapshotShardFailure exp = new SnapshotShardFailure();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.nodeId = in.readOptionalString();
        this.index = in.readString();
        this.shardId = in.readVInt();
        this.reason = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.nodeId);
        out.writeString(this.index);
        out.writeVInt(this.shardId);
        out.writeString(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason + "]";
    }

    public static void toXContent(SnapshotShardFailure snapshotShardFailure, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (snapshotShardFailure.nodeId != null) {
            builder.field("node_id", snapshotShardFailure.nodeId);
        }
        builder.field("index", snapshotShardFailure.index);
        builder.field("reason", snapshotShardFailure.reason);
        builder.field("shard_id", snapshotShardFailure.shardId);
        builder.field("status", snapshotShardFailure.status.name());
        builder.endObject();
    }

    public static SnapshotShardFailure fromXContent(XContentParser parser) throws IOException {
        SnapshotShardFailure snapshotShardFailure = new SnapshotShardFailure();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (!token.isValue()) continue;
                    if ("index".equals(currentFieldName)) {
                        snapshotShardFailure.index = parser.text();
                        continue;
                    }
                    if ("node_id".equals(currentFieldName)) {
                        snapshotShardFailure.nodeId = parser.text();
                        continue;
                    }
                    if ("reason".equals(currentFieldName)) {
                        snapshotShardFailure.reason = parser.text();
                        continue;
                    }
                    if ("shard_id".equals(currentFieldName)) {
                        snapshotShardFailure.shardId = parser.intValue();
                        continue;
                    }
                    if ("status".equals(currentFieldName)) {
                        snapshotShardFailure.status = RestStatus.valueOf(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("unknown parameter [" + currentFieldName + "]");
                }
                throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
            }
        } else {
            throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
        }
        return snapshotShardFailure;
    }
}

