/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.io.Serializable;
import java.util.Set;
import org.vertexium.Metadata;
import org.vertexium.Visibility;

public class HistoricalPropertyValue
implements Serializable,
Comparable<HistoricalPropertyValue> {
    static final long serialVersionUID = 42L;
    private final String propertyKey;
    private final String propertyName;
    private final Visibility propertyVisibility;
    private final long timestamp;
    private final Object value;
    private final Metadata metadata;
    private Set<Visibility> hiddenVisibilities;

    public HistoricalPropertyValue(String propertyKey, String propertyName, Visibility propertyVisibility, long timestamp, Object value, Metadata metadata, Set<Visibility> hiddenVisibilities) {
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyVisibility = propertyVisibility;
        this.timestamp = timestamp;
        this.value = value;
        this.metadata = metadata;
        this.hiddenVisibilities = hiddenVisibilities;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Visibility getPropertyVisibility() {
        return this.propertyVisibility;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Object getValue() {
        return this.value;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Set<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalPropertyValue that = (HistoricalPropertyValue)o;
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (!this.propertyKey.equals(that.propertyKey)) {
            return false;
        }
        if (!this.propertyName.equals(that.propertyName)) {
            return false;
        }
        return this.propertyVisibility.equals(that.propertyVisibility);
    }

    public int hashCode() {
        int result = this.propertyKey.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        result = 31 * result + this.propertyVisibility.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    @Override
    public int compareTo(HistoricalPropertyValue o) {
        int result = -Long.compare(this.getTimestamp(), o.getTimestamp());
        if (result != 0) {
            return result;
        }
        result = this.getPropertyName().compareTo(o.getPropertyName());
        if (result != 0) {
            return result;
        }
        result = this.getPropertyKey().compareTo(o.getPropertyKey());
        if (result != 0) {
            return result;
        }
        result = this.getPropertyVisibility().compareTo(o.getPropertyVisibility());
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return "HistoricalPropertyValue{propertyKey='" + this.propertyKey + '\'' + ", propertyName='" + this.propertyName + '\'' + ", propertyVisibility=" + this.propertyVisibility + ", timestamp=" + this.timestamp + ", value=" + this.value + '}';
    }
}

