/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.Collection;
import java.util.EnumSet;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.query.Aggregation;
import org.vertexium.query.DefaultGraphQueryIterableWithAggregations;
import org.vertexium.query.GraphQueryBase;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class DefaultGraphQuery
extends GraphQueryBase {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(DefaultGraphQuery.class);

    public DefaultGraphQuery(Graph graph, String queryString, Authorizations authorizations) {
        super(graph, queryString, authorizations);
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(EnumSet<FetchHint> fetchHints) {
        LOGGER.warn("scanning all vertices! create your own GraphQuery.", new Object[0]);
        return new DefaultGraphQueryIterableWithAggregations<Vertex>(this.getParameters(), this.getIterableFromElementType(ElementType.VERTEX, fetchHints), true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    @Override
    public QueryResultsIterable<Edge> edges(EnumSet<FetchHint> fetchHints) {
        LOGGER.warn("scanning all edges! create your own GraphQuery.", new Object[0]);
        return new DefaultGraphQueryIterableWithAggregations<Edge>(this.getParameters(), this.getIterableFromElementType(ElementType.EDGE, fetchHints), true, true, true, (Collection<Aggregation>)this.getAggregations());
    }

    private <T extends Element> Iterable<T> getIterableFromElementType(ElementType elementType, EnumSet<FetchHint> fetchHints) throws VertexiumException {
        switch (elementType) {
            case VERTEX: {
                return this.getGraph().getVertices(fetchHints, this.getParameters().getAuthorizations());
            }
            case EDGE: {
                return this.getGraph().getEdges(fetchHints, this.getParameters().getAuthorizations());
            }
        }
        throw new VertexiumException("Unexpected element type: " + (Object)((Object)elementType));
    }

    @Override
    public boolean isAggregationSupported(Aggregation aggregation) {
        if (DefaultGraphQueryIterableWithAggregations.isAggregationSupported(aggregation)) {
            return true;
        }
        return super.isAggregationSupported(aggregation);
    }
}

