/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.vertexium.Element;
import org.vertexium.VertexiumException;
import org.vertexium.query.Aggregation;
import org.vertexium.query.AggregationResult;
import org.vertexium.query.DefaultGraphQueryIterable;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TermsBucket;
import org.vertexium.query.TermsResult;

public class DefaultGraphQueryIterableWithAggregations<T extends Element>
extends DefaultGraphQueryIterable<T> {
    private final Collection<Aggregation> aggregations;

    public DefaultGraphQueryIterableWithAggregations(QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, Collection<Aggregation> aggregations) {
        super(parameters, iterable, evaluateQueryString, evaluateHasContainers, evaluateSortContainers);
        this.aggregations = aggregations;
    }

    @Override
    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        for (Aggregation agg : this.aggregations) {
            if (!agg.getAggregationName().equals(name)) continue;
            return this.getAggregationResult(agg, this.iterator(true));
        }
        return super.getAggregationResult(name, resultType);
    }

    public static boolean isAggregationSupported(Aggregation agg) {
        return agg instanceof TermsAggregation;
    }

    public <TResult extends AggregationResult> TResult getAggregationResult(Aggregation agg, Iterator<T> it) {
        if (agg instanceof TermsAggregation) {
            return this.getTermsAggregationResult((TermsAggregation)agg, it);
        }
        throw new VertexiumException("Unhandled aggregation: " + agg.getClass().getName());
    }

    private <TResult extends AggregationResult> TResult getTermsAggregationResult(TermsAggregation agg, Iterator<T> it) {
        String propertyName = agg.getPropertyName();
        Map<Object, List<T>> elementsByProperty = this.getElementsByProperty(it, propertyName);
        ArrayList<TermsBucket> buckets = new ArrayList<TermsBucket>();
        for (Map.Entry<Object, List<T>> entry : elementsByProperty.entrySet()) {
            Object key = entry.getKey();
            int count = entry.getValue().size();
            Map<String, AggregationResult> nestedResults = this.getNestedResults(agg.getNestedAggregations(), entry.getValue());
            buckets.add(new TermsBucket(key, count, nestedResults));
        }
        return (TResult)new TermsResult(buckets);
    }

    private Map<String, AggregationResult> getNestedResults(Iterable<Aggregation> nestedAggregations, List<T> elements) {
        HashMap<String, AggregationResult> results = new HashMap<String, AggregationResult>();
        for (Aggregation nestedAggregation : nestedAggregations) {
            Object nestedResult = this.getAggregationResult(nestedAggregation, elements.iterator());
            results.put(nestedAggregation.getAggregationName(), (AggregationResult)nestedResult);
        }
        return results;
    }

    private Map<Object, List<T>> getElementsByProperty(Iterator<T> it, String propertyName) {
        HashMap<Object, List<T>> elementsByProperty = new HashMap<Object, List<T>>();
        while (it.hasNext()) {
            Element elem = (Element)it.next();
            Iterable<Object> values = elem.getPropertyValues(propertyName);
            for (Object value : values) {
                ArrayList<Element> list = (ArrayList<Element>)elementsByProperty.get(value);
                if (list == null) {
                    list = new ArrayList<Element>();
                    elementsByProperty.put(value, list);
                }
                list.add(elem);
            }
        }
        return elementsByProperty;
    }
}

