/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.query.graph;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.BackendTransaction;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.graphdb.query.BackendQuery;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MultiKeySliceQuery
extends BaseQuery
implements BackendQuery<MultiKeySliceQuery> {
    private final List<KeySliceQuery> queries;

    public MultiKeySliceQuery(List<KeySliceQuery> queries) {
        Preconditions.checkArgument((queries != null && !queries.isEmpty() ? 1 : 0) != 0);
        this.queries = queries;
    }

    @Override
    public MultiKeySliceQuery updateLimit(int newLimit) {
        MultiKeySliceQuery newQuery = new MultiKeySliceQuery(this.queries);
        newQuery.setLimit(newLimit);
        return newQuery;
    }

    public List<EntryList> execute(BackendTransaction tx) {
        int total = 0;
        ArrayList<EntryList> result = new ArrayList<EntryList>(4);
        for (KeySliceQuery ksq : this.queries) {
            EntryList next = tx.indexQuery(ksq.updateLimit(this.getLimit() - total));
            result.add(next);
            if ((total += next.size()) < this.getLimit()) continue;
            break;
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.queries).appendSuper(super.hashCode()).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().isInstance(other)) {
            return false;
        }
        MultiKeySliceQuery oth = (MultiKeySliceQuery)other;
        return this.getLimit() == oth.getLimit() && this.queries.equals(oth.queries);
    }

    public String toString() {
        return "multiKSQ[" + this.queries.size() + "]@" + this.getLimit();
    }
}

