/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.hadoop.config.HBaseAuthHelper;
import com.thinkaurelius.titan.hadoop.config.HybridConfigured;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.Inverter;
import com.thinkaurelius.titan.hadoop.hdfs.HDFSTools;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;

public class HadoopGraph
extends HybridConfigured {
    public HadoopGraph() {
        this(new Configuration());
    }

    public HadoopGraph(Configuration configuration) {
        super(HBaseAuthHelper.wrapConfiguration(configuration));
    }

    public Configuration getConf(String prefix) {
        EmptyConfiguration prefixConf = new EmptyConfiguration();
        for (Map.Entry entry : this.getConf()) {
            if (!((String)entry.getKey()).startsWith(prefix + ".")) continue;
            prefixConf.set((String)entry.getKey(), (String)entry.getValue());
        }
        return prefixConf;
    }

    public Class<? extends InputFormat> getGraphInputFormat() {
        return this.titanConf.getClass(TitanHadoopConfiguration.INPUT_FORMAT, InputFormat.class, InputFormat.class);
    }

    public void setGraphInputFormat(Class<? extends InputFormat> format) {
        this.titanConf.setClass(TitanHadoopConfiguration.INPUT_FORMAT, format, InputFormat.class);
    }

    public Class<? extends OutputFormat> getGraphOutputFormat() {
        return this.titanConf.getClass(TitanHadoopConfiguration.OUTPUT_FORMAT, OutputFormat.class, OutputFormat.class);
    }

    public void setGraphOutputFormat(Class<? extends OutputFormat<?, ?>> format) {
        this.titanConf.setClass(TitanHadoopConfiguration.OUTPUT_FORMAT, format, OutputFormat.class);
    }

    public Class<? extends OutputFormat> getSideEffectOutputFormat() {
        return this.titanConf.getClass(TitanHadoopConfiguration.SIDE_EFFECT_FORMAT, OutputFormat.class, OutputFormat.class);
    }

    public void setSideEffectOutputFormat(Class<? extends OutputFormat<?, ?>> format) {
        this.titanConf.setClass(TitanHadoopConfiguration.SIDE_EFFECT_FORMAT, format, OutputFormat.class);
    }

    public Path getInputLocation() {
        if (!this.getTitanConf().has(TitanHadoopConfiguration.INPUT_LOCATION, new String[0])) {
            return null;
        }
        return new Path(this.getTitanConf().get(TitanHadoopConfiguration.INPUT_LOCATION, new String[0]));
    }

    public void setInputLocation(Path path) {
        this.getTitanConf().set(TitanHadoopConfiguration.INPUT_LOCATION, path.toString(), new String[0]);
    }

    public void setInputLocation(String path) {
        this.setInputLocation(new Path(path));
    }

    public boolean hasEdgeCopyDirection() {
        ModifiableHadoopConfiguration mc = this.getTitanConf();
        return mc.has(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIR, new String[0]) || mc.has(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIRECTION, new String[0]);
    }

    public Direction getEdgeCopyDirection() {
        return this.getTitanConf().getEdgeCopyDirection();
    }

    public Path getJobDir() {
        return new Path(this.getTitanConf().get(TitanHadoopConfiguration.JOBDIR_LOCATION, new String[0]));
    }

    public void setJobDir(Path path) {
        this.getTitanConf().set(TitanHadoopConfiguration.JOBDIR_LOCATION, path.toString(), new String[0]);
    }

    public void setJobDir(String path) {
        this.setJobDir(new Path(path));
    }

    public boolean getJobDirOverwrite() {
        return this.getTitanConf().get(TitanHadoopConfiguration.JOBDIR_OVERWRITE, new String[0]);
    }

    public FileSystem getFileSystem() throws IOException {
        return FileSystem.get((Configuration)this.getConf());
    }

    public boolean getTrackPaths() {
        return this.getTitanConf().get(TitanHadoopConfiguration.PIPELINE_TRACK_PATHS, new String[0]);
    }

    public boolean getTrackState() {
        return this.getTitanConf().get(TitanHadoopConfiguration.PIPELINE_TRACK_STATE, new String[0]);
    }

    public void shutdown() {
        this.clearConfiguration();
    }

    public String toString() {
        return String.format("titangraph[hadoop:%s->%s]", this.titanConf.getClass(TitanHadoopConfiguration.INPUT_FORMAT, InputFormat.class).getSimpleName().toLowerCase(), this.titanConf.getClass(TitanHadoopConfiguration.OUTPUT_FORMAT, OutputFormat.class).getSimpleName().toLowerCase());
    }

    public HadoopGraph getNextGraph() throws IOException {
        HadoopGraph graph = new HadoopGraph(this.getConf());
        if (null != this.getGraphOutputFormat()) {
            graph.setGraphInputFormat(Inverter.invertOutputFormat(this.getGraphOutputFormat()));
        }
        if (null != this.getJobDir()) {
            graph.setInputLocation(HDFSTools.getOutputsFinalJob(FileSystem.get((Configuration)this.getConf()), this.getJobDir().toString()));
            graph.setJobDir(new Path(this.getJobDir().toString() + "_"));
        }
        return graph;
    }
}

