/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.driver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mrunit.TestDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class MultipleInputsMapReduceDriverBase<M, K1, V1, K2, V2, T extends MultipleInputsMapReduceDriverBase<M, K1, V1, K2, V2, T>>
extends TestDriver<K2, V2, T> {
    public static final Log LOG = LogFactory.getLog(MultipleInputsMapReduceDriverBase.class);
    protected Map<M, Path> mapInputPaths = new HashMap<M, Path>();
    protected Comparator<K1> keyGroupComparator;
    protected Comparator<K1> keyValueOrderComparator;
    protected Map<M, List<Pair>> inputs = new HashMap<M, List<Pair>>();

    public Path getMapInputPath(M mapper) {
        return this.mapInputPaths.get(mapper);
    }

    public void setMapInputPath(M mapper, Path mapInputPath) {
        this.mapInputPaths.put(mapper, mapInputPath);
    }

    public final T withMapInputPath(M mapper, Path mapInputPath) {
        this.setMapInputPath(mapper, mapInputPath);
        return this.thisAsMapReduceDriver();
    }

    public void setKeyGroupingComparator(RawComparator<K2> groupingComparator) {
        this.keyGroupComparator = (Comparator)ReflectionUtils.newInstance(groupingComparator.getClass(), (Configuration)this.getConfiguration());
    }

    public T withKeyGroupingComparator(RawComparator<K2> groupingComparator) {
        this.setKeyGroupingComparator(groupingComparator);
        return this.thisAsMapReduceDriver();
    }

    public void setKeyOrderComparator(RawComparator<K2> orderComparator) {
        this.keyValueOrderComparator = (Comparator)ReflectionUtils.newInstance(orderComparator.getClass(), (Configuration)this.getConfiguration());
    }

    public T withKeyOrderComparator(RawComparator<K2> orderComparator) {
        this.setKeyOrderComparator(orderComparator);
        return this.thisAsMapReduceDriver();
    }

    protected <K, V> void addInput(M mapper, K key, V val) {
        if (!this.inputs.containsKey(mapper)) {
            this.inputs.put(mapper, new ArrayList());
        }
        this.inputs.get(mapper).add(this.copyPair(key, val));
    }

    protected <K, V> void addInput(M mapper, Pair<K, V> input) {
        this.addInput(mapper, input.getFirst(), input.getSecond());
    }

    protected <K, V> void addAll(M mapper, List<Pair<K, V>> inputs) {
        for (Pair<K, V> input : inputs) {
            this.addInput(mapper, input);
        }
    }

    protected <K, V> T withInput(M mapper, K key, V val) {
        this.addInput(mapper, key, val);
        return this.thisAsMapReduceDriver();
    }

    protected <K, V> T withInput(M mapper, Pair<K, V> input) {
        this.addInput(mapper, input);
        return this.thisAsMapReduceDriver();
    }

    protected <K, V> T withAll(M mapper, List<Pair<K, V>> inputs) {
        this.addAll(mapper, inputs);
        return this.thisAsMapReduceDriver();
    }

    protected void preRunChecks(Set<M> mappers, Object reducer) {
        for (M mapper : mappers) {
            if (this.inputs.get(mapper) != null && !this.inputs.get(mapper).isEmpty()) continue;
            throw new IllegalStateException(String.format("No input was provided for mapper %s", mapper));
        }
        if (reducer == null) {
            throw new IllegalStateException("No reducer class was provided");
        }
        if (this.driverReused()) {
            throw new IllegalStateException("Driver reuse not allowed");
        }
        this.setUsedOnceStatus();
    }

    private T thisAsMapReduceDriver() {
        return (T)this;
    }
}

