/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.mapreduce;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mrunit.internal.mapreduce.ContextDriver;
import org.apache.hadoop.mrunit.internal.output.MockOutputCreator;
import org.apache.hadoop.mrunit.internal.output.OutputCollectable;
import org.apache.hadoop.mrunit.types.Pair;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

abstract class AbstractMockContextWrapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT, CONTEXT extends TaskInputOutputContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT>> {
    protected CONTEXT context;
    protected final MockOutputCreator<KEYOUT, VALUEOUT> mockOutputCreator;
    protected final Configuration configuration;
    protected OutputCollectable<KEYOUT, VALUEOUT> outputCollectable;

    public AbstractMockContextWrapper(Configuration configuration, MockOutputCreator<KEYOUT, VALUEOUT> mockOutputCreator) {
        this.mockOutputCreator = mockOutputCreator;
        this.configuration = configuration;
    }

    protected void createCommon(final TaskInputOutputContext context, final ContextDriver contextDriver, final MockOutputCreator mockOutputCreator) {
        Mockito.when((Object)context.getCounter((Enum)Mockito.any())).thenAnswer((Answer)new Answer<Counter>(){

            public Counter answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                return contextDriver.getCounters().findCounter((Enum)args[0]);
            }
        });
        Mockito.when((Object)context.getCounter(Mockito.anyString(), Mockito.anyString())).thenAnswer((Answer)new Answer<Counter>(){

            public Counter answer(InvocationOnMock invocation) {
                Object[] args = invocation.getArguments();
                return contextDriver.getCounters().findCounter((String)args[0], (String)args[1]);
            }
        });
        Mockito.when((Object)context.getConfiguration()).thenAnswer((Answer)new Answer<Configuration>(){

            public Configuration answer(InvocationOnMock invocation) {
                return contextDriver.getConfiguration();
            }
        });
        try {
            ((TaskInputOutputContext)Mockito.doAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) {
                    Object[] args = invocation.getArguments();
                    try {
                        if (AbstractMockContextWrapper.this.outputCollectable == null) {
                            AbstractMockContextWrapper.this.outputCollectable = mockOutputCreator.createMapReduceOutputCollectable(contextDriver.getConfiguration(), contextDriver.getOutputSerializationConfiguration(), context);
                        }
                        AbstractMockContextWrapper.this.outputCollectable.collect(args[0], args[1]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            }).when((Object)context)).write(Mockito.any(), Mockito.any());
            Mockito.when((Object)context.getSymlink()).thenAnswer((Answer)new Answer<Boolean>(){

                public Boolean answer(InvocationOnMock invocation) throws Throwable {
                    return DistributedCache.getSymlink((Configuration)AbstractMockContextWrapper.this.configuration);
                }
            });
            Mockito.when((Object)context.getCacheArchives()).thenAnswer((Answer)new Answer<URI[]>(){

                public URI[] answer(InvocationOnMock invocation) throws Throwable {
                    return DistributedCache.getCacheArchives((Configuration)AbstractMockContextWrapper.this.configuration);
                }
            });
            Mockito.when((Object)context.getCacheFiles()).thenAnswer((Answer)new Answer<URI[]>(){

                public URI[] answer(InvocationOnMock invocation) throws Throwable {
                    return DistributedCache.getCacheFiles((Configuration)AbstractMockContextWrapper.this.configuration);
                }
            });
            Mockito.when((Object)context.getLocalCacheArchives()).thenAnswer((Answer)new Answer<Path[]>(){

                public Path[] answer(InvocationOnMock invocation) throws Throwable {
                    return DistributedCache.getLocalCacheArchives((Configuration)AbstractMockContextWrapper.this.configuration);
                }
            });
            Mockito.when((Object)context.getLocalCacheFiles()).thenAnswer((Answer)new Answer<Path[]>(){

                public Path[] answer(InvocationOnMock invocation) throws Throwable {
                    return DistributedCache.getLocalCacheFiles((Configuration)AbstractMockContextWrapper.this.configuration);
                }
            });
            Mockito.when((Object)context.getNumReduceTasks()).thenAnswer((Answer)new Answer<Integer>(){

                public Integer answer(InvocationOnMock invocation) throws Throwable {
                    return AbstractMockContextWrapper.this.configuration.getInt("mapred.reduce.tasks", 1);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract CONTEXT create() throws IOException, InterruptedException;

    public List<Pair<KEYOUT, VALUEOUT>> getOutputs() throws IOException {
        if (this.outputCollectable == null) {
            return new ArrayList<Pair<KEYOUT, VALUEOUT>>();
        }
        return this.outputCollectable.getOutputs();
    }

    public CONTEXT getMockContext() {
        return this.context;
    }
}

