/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.AbstractInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputFormatBase;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Level;

public class AccumuloInputFormat
extends InputFormatBase<Key, Value> {
    public RecordReader<Key, Value> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        RangeInputSplit risplit;
        Level level;
        log.setLevel(AccumuloInputFormat.getLogLevel((JobContext)context));
        if (split instanceof RangeInputSplit && null != (level = (risplit = (RangeInputSplit)split).getLogLevel())) {
            log.setLevel(level);
        }
        return new InputFormatBase.RecordReaderBase<Key, Value>(){

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    this.currentK = this.currentKey;
                    this.currentV = entry.getValue();
                    if (AbstractInputFormat.log.isTraceEnabled()) {
                        AbstractInputFormat.log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry<Key, Value>)entry, true)));
                    }
                    return true;
                }
                return false;
            }
        };
    }
}

